/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public abstract class ChangeNotationAction
extends DiagramAction {
    private CreateViewRequest myCreateViewRequest;

    public ChangeNotationAction(IWorkbenchPage workbenchPage, String actionId) {
        super(workbenchPage);
        this.setId(actionId);
    }

    public void init() {
        super.init();
        this.updateText();
        this.updateImage();
    }

    public void refresh() {
        super.refresh();
        this.updateText();
        this.updateImage();
    }

    protected abstract String getSemanticHint(GraphicalEditPart var1);

    protected void updateImage() {
    }

    protected void updateText() {
    }

    protected final Request createTargetRequest() {
        return null;
    }

    protected final Command getCommand() {
        GraphicalEditPart editPart = this.getSelectedEditPart();
        if (editPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Command deleteCommand = this.getDeleteViewCommand(editPart);
        if (deleteCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Command createViewCommand = this.getCreateViewCommand(editPart);
        if (createViewCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand(this.getCommandLabel());
        command.add(deleteCommand);
        command.add(createViewCommand);
        return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
    }

    protected final Command getDeleteViewCommand(GraphicalEditPart editPart) {
        View view = (View)editPart.getModel();
        return new ICommandProxy((ICommand)new DeleteCommand(view));
    }

    protected final Command getCreateViewCommand(GraphicalEditPart editPart) {
        this.myCreateViewRequest = this.getCreateViewRequest(editPart);
        if (this.myCreateViewRequest == null) {
            return null;
        }
        return editPart.getParent().getCommand((Request)this.myCreateViewRequest);
    }

    protected final CreateViewRequest getCreateViewRequest(GraphicalEditPart editPart) {
        View view = (View)editPart.getModel();
        EObject element = view.getElement();
        String semanticHint = this.getSemanticHint(editPart);
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(element), Node.class, semanticHint, this.getPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptor);
        createViewRequest.setLocation(this.getLocation(editPart));
        return createViewRequest;
    }

    protected final boolean isSelectionListener() {
        return true;
    }

    protected final GraphicalEditPart getSelectedEditPart() {
        for (Object ob : this.getSelectedObjects()) {
            if (!(ob instanceof GraphicalEditPart)) continue;
            return (GraphicalEditPart)ob;
        }
        return null;
    }

    private Point getLocation(GraphicalEditPart editPart) {
        Rectangle b = editPart.getFigure().getBounds().getCopy();
        editPart.getFigure().translateToAbsolute((Translatable)b);
        return b.getLocation();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        super.doRun(progressMonitor);
        this.selectAddedObject();
        this.myCreateViewRequest = null;
    }

    private void selectAddedObject() {
        if (this.myCreateViewRequest == null) {
            return;
        }
        Object result = this.myCreateViewRequest.getNewObject();
        if (!(result instanceof Collection)) {
            return;
        }
        final ArrayList editparts = new ArrayList(1);
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        if (viewer == null) {
            return;
        }
        Map editpartRegistry = viewer.getEditPartRegistry();
        for (Object viewAdaptable : (Collection)result) {
            Object editPart;
            if (!(viewAdaptable instanceof IAdaptable) || (editPart = editpartRegistry.get(((IAdaptable)viewAdaptable).getAdapter(View.class))) == null) continue;
            editparts.add(editPart);
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    EditPart editPart = (EditPart)editparts.get(0);
                    editPart.performRequest(new Request((Object)"direct edit"));
                }
            });
        }
    }
}

