/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.launch;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class EmptyDebugTarget
extends PlatformObject
implements IDebugTarget {
    private final ILaunch myLaunch;
    private final IProcess myProcess;
    private final String myModelId;
    private final String myName;
    private boolean myIsTerminated;

    public EmptyDebugTarget(ILaunch launch, IProcess process, String modelId, String name) {
        this.myLaunch = launch;
        this.myProcess = process;
        this.myModelId = modelId;
        this.myName = name;
        this.myIsTerminated = false;
    }

    public IProcess getProcess() {
        return this.myProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return new IThread[0];
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public String getName() throws DebugException {
        return this.myName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public String getModelIdentifier() {
        return this.myModelId;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.myLaunch;
    }

    public boolean canTerminate() {
        return !this.myIsTerminated;
    }

    public void terminate() throws DebugException {
        DebugEvent terminatedEvent = new DebugEvent((Object)this, 8);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{terminatedEvent});
        this.myIsTerminated = true;
    }

    public boolean isTerminated() {
        return this.myIsTerminated;
    }

    public boolean canResume() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public boolean canSuspend() {
        return false;
    }

    public void suspend() throws DebugException {
    }

    public boolean isSuspended() {
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }
}

