/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebugEnvironmentFactory;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebuggableExecutorAdapter;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTODebuggerShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTransformationRunner
extends TransformationRunner {
    private IQVTODebuggerShell fDebugShell;
    private PrintWriter fErrorLog = new PrintWriter(new OutputStream(){

        public void write(int b) throws IOException {
        }
    }, true);

    public DebugTransformationRunner(URI transformationURI, EPackage.Registry packageRegistry, List<URI> modelParamURIs) {
        super(transformationURI, packageRegistry, modelParamURIs);
    }

    public void setErrorLog(PrintWriter errorLog) {
        if (errorLog == null) {
            throw new IllegalArgumentException();
        }
        this.fErrorLog = errorLog;
    }

    protected QvtOperationalEnvFactory getEnvFactory() {
        if (this.fDebugShell != null) {
            return new DebugEnvironmentFactory(this.fDebugShell);
        }
        return super.getEnvFactory();
    }

    protected void handleLoadExtents(Diagnostic diagnostic) {
    }

    protected void handleLoadTransformation(Diagnostic diagnostic) {
    }

    protected void handleExecution(ExecutionDiagnostic execDiagnostic) {
        List stackTrace = execDiagnostic.getStackTrace();
        if (stackTrace != null && execDiagnostic.getCode() != 110 && !stackTrace.isEmpty()) {
            this.fErrorLog.println("[QVTO Stack trace:]");
            execDiagnostic.printStackTrace(this.fErrorLog);
            this.fErrorLog.println();
        }
        if (execDiagnostic.getException() != null) {
            this.fErrorLog.println("[Java cause:]");
            execDiagnostic.getException().printStackTrace(this.fErrorLog);
        }
        this.fErrorLog.flush();
    }

    protected void handleSaveExtents(Diagnostic diagnostic) {
    }

    public DebuggableExecutorAdapter createDebugableAdapter(final ExecutionContext context) {
        return new DebuggableExecutorAdapter(){

            public Diagnostic execute() throws IllegalStateException {
                if (DebugTransformationRunner.this.fDebugShell == null) {
                    throw new IllegalStateException("Executor not connected to debugger");
                }
                CompiledUnit mainUnit = DebugTransformationRunner.this.getExecutor().getUnit();
                if (mainUnit != null) {
                    QVTODebugUtil.attachEnvironment(mainUnit);
                }
                Diagnostic execDiagnostic = DebugTransformationRunner.this.execute(context);
                DebugTransformationRunner.this.fErrorLog.println(execDiagnostic);
                return execDiagnostic;
            }

            public CompiledUnit getUnit() {
                return DebugTransformationRunner.this.getExecutor().getUnit();
            }

            public void connect(IQVTODebuggerShell debugShell) {
                DebugTransformationRunner.this.fDebugShell = debugShell;
            }
        };
    }
}

