/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.parser.packrat.IBacktracker;
import org.eclipse.xtext.parser.packrat.ICharSequenceWithOffset;
import org.eclipse.xtext.parser.packrat.IMarkerFactory;
import org.eclipse.xtext.parser.packrat.IParsedTokenVisitor;
import org.eclipse.xtext.parser.packrat.internal.MarkerAwareBacktracker;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.IParsedTokenAcceptor;

public class Marker
extends AbstractParsedToken
implements IMarkerFactory.IMarker,
IParsedTokenAcceptor,
IBacktracker {
    private static final int INITIAL_CONTENT_SIZE = 100;
    private IMarkerClient client;
    private Marker parent;
    private int danglingChildCount;
    private int lastOffset;
    private final List<AbstractParsedToken> content = new ArrayList<AbstractParsedToken>(100);
    private ICharSequenceWithOffset input;
    private IBacktracker backtracker;

    public Marker(Marker parent, int offset, ICharSequenceWithOffset input, IMarkerClient client) {
        super(offset, 0);
        this.init(parent, input, client);
    }

    private void init(Marker parent, ICharSequenceWithOffset input, IMarkerClient client) {
        this.lastOffset = -1;
        this.parent = parent;
        if (this.parent != null) {
            ++this.parent.danglingChildCount;
        }
        this.input = input;
        this.client = client;
        this.client.setActiveMarker(this);
    }

    public Marker reInit(int offset, Marker parent, ICharSequenceWithOffset input, IMarkerClient client) {
        this.setOffset(offset);
        this.init(parent, input, client);
        return this;
    }

    @Override
    public void rollback() {
        if (this.danglingChildCount > 0) {
            throw new IllegalStateException("childCount has to be zero before rollback.");
        }
        this.input.setOffset(this.getOffset());
        this.client.setActiveMarker(this.parent);
        this.forget();
    }

    @Override
    public void flush() {
        if (this.danglingChildCount > 0) {
            throw new IllegalStateException("childCount has to be zero before flush.");
        }
        if (this.parent != null) {
            if (this.parent.danglingChildCount > 1) {
                throw new IllegalStateException("cannot flush if there exist any forked children.");
            }
        } else {
            throw new IllegalStateException("Cannot flush root marker.");
        }
        this.parent.content.addAll(this.content);
        this.content.clear();
        this.setOffset(this.input.getOffset());
        this.lastOffset = this.input.getOffset();
    }

    @Override
    public void commit() {
        if (this.danglingChildCount > 0) {
            throw new IllegalStateException("childCount has to be zero before commit.");
        }
        if (this.parent != null) {
            if (this.parent.danglingChildCount != 1) {
                throw new IllegalStateException("cannot commit if there exist any other forked children.");
            }
            if (!this.content.isEmpty()) {
                this.parent.content.addAll(this.content);
            }
            this.client.releaseMarker(this);
            this.content.clear();
            --this.parent.danglingChildCount;
        }
        this.client.setActiveMarker(this.parent);
        this.parent = null;
    }

    @Override
    public Marker fork() {
        this.lastOffset = this.input.getOffset();
        this.input.setOffset(this.getOffset());
        return this.client.getNextMarker(this.parent, this.getOffset());
    }

    public Marker forkAfterSkipped(int before) {
        Marker result = this.fork();
        if (before >= 1) {
            result.content.addAll(this.content.subList(0, before));
        }
        return result;
    }

    @Override
    public IMarkerFactory.IMarker join(IMarkerFactory.IMarker forkedMarker) {
        if (!(forkedMarker instanceof Marker)) {
            throw new IllegalArgumentException("forkedMarker is not supported: " + forkedMarker);
        }
        Marker joinMe = (Marker)forkedMarker;
        if (joinMe.parent != this.parent) {
            throw new IllegalStateException("cannot join with a marker, that has another parent.");
        }
        this.client.setActiveMarker(this);
        if (this.lastOffset != -1) {
            this.getInput().setOffset(this.lastOffset);
        }
        joinMe.forget();
        if (this.parent != null && this.parent.danglingChildCount < 1) {
            throw new IllegalStateException("parent should have at least one dangling child after join.");
        }
        return this;
    }

    void forget() {
        if (this.parent != null) {
            --this.parent.danglingChildCount;
            if (this.parent.danglingChildCount < 0) {
                throw new IllegalStateException("childCount may not be smaller than zero.");
            }
        }
        this.client.releaseMarker(this);
        this.backtracker = null;
        this.parent = null;
        this.content.clear();
    }

    public List<AbstractParsedToken> getContent() {
        return this.content;
    }

    public Marker getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " dangling children: '" + this.danglingChildCount + "' actual content: '" + this.content.size() + "'";
    }

    @Override
    public void accept(IParsedTokenVisitor visitor) {
        if (this.danglingChildCount != 0) {
            throw new IllegalStateException("cannot accept visitor if there exist any dangling children.");
        }
        if (visitor instanceof IMarkerVisitor) {
            ((IMarkerVisitor)visitor).visitMarker(this);
        } else {
            int i = 0;
            while (i < this.content.size()) {
                this.content.get(i).accept(visitor);
                ++i;
            }
        }
    }

    @Override
    public void accept(AbstractParsedToken token) {
        if (this.danglingChildCount != 0) {
            throw new IllegalStateException("cannot accept tokens if there exist any dangling children.");
        }
        this.content.add(token);
    }

    public void setClient(IMarkerClient client) {
        this.client = client;
    }

    public IMarkerClient getClient() {
        return this.client;
    }

    public void setInput(ICharSequenceWithOffset input) {
        this.input = input;
    }

    public ICharSequenceWithOffset getInput() {
        return this.input;
    }

    @Override
    public IBacktracker.IBacktrackingResult skipPreviousToken() {
        if (this.danglingChildCount > 0) {
            throw new IllegalStateException("childCount has to be zero before backtracking.");
        }
        if (this.backtracker == null) {
            this.backtracker = new MarkerAwareBacktracker(this);
        }
        return this.backtracker.skipPreviousToken();
    }

    public void discardLastOffset() {
        this.lastOffset = -1;
    }

    public void replaceContent(List<AbstractParsedToken> tokens) {
        this.content.clear();
        this.content.addAll(tokens);
    }

    public static interface IMarkerClient
    extends IMarkerFactory {
        public void setActiveMarker(Marker var1);

        public Marker getActiveMarker();

        public Marker getNextMarker(Marker var1, int var2);

        public void releaseMarker(Marker var1);
    }

    public static interface IMarkerVisitor
    extends IParsedTokenVisitor {
        public void visitMarker(Marker var1);
    }
}

