/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.util.Pair;

public class ToBeBuiltComputer {
    @Inject
    private IBuilderState builderState;
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private UriValidator uriValidator;

    public ToBeBuilt removeProject(IProject project, IProgressMonitor monitor) {
        return this.doRemoveProject(project, monitor);
    }

    protected ToBeBuilt doRemoveProject(IProject project, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)Iterables.size((Iterable)this.builderState.getAllResourceDescriptions()));
        ToBeBuilt result = new ToBeBuilt();
        Iterable allResourceDescriptions = this.builderState.getAllResourceDescriptions();
        for (IResourceDescription description : allResourceDescriptions) {
            Iterable storages = this.mapper.getStorages(description.getURI());
            boolean onlyOnThisProject = true;
            Iterator iterator = storages.iterator();
            while (iterator.hasNext() && onlyOnThisProject) {
                Pair storage2Project = (Pair)iterator.next();
                boolean isSameProject = project.equals(storage2Project.getSecond());
                boolean bl = onlyOnThisProject = isSameProject || !((IProject)storage2Project.getSecond()).isAccessible();
            }
            if (onlyOnThisProject) {
                result.getToBeDeleted().add(description.getURI());
            }
            progress.worked(1);
        }
        return result;
    }

    public ToBeBuilt updateProjectNewResourcesOnly(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ToBeBuiltComputer_CollectingReosurces, (int)1);
        progress.subTask(Messages.ToBeBuiltComputer_CollectingReosurces);
        ToBeBuilt toBeBuilt = this.updateProject(project, (IProgressMonitor)progress.newChild(1));
        Iterable existingURIs = Iterables.transform((Iterable)this.builderState.getAllResourceDescriptions(), (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        });
        for (URI existingURI : existingURIs) {
            toBeBuilt.getToBeDeleted().remove(existingURI);
            toBeBuilt.getToBeUpdated().remove(existingURI);
        }
        return toBeBuilt;
    }

    public ToBeBuilt updateProject(IProject project, IProgressMonitor monitor) throws CoreException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ToBeBuiltComputer_CollectingReosurces, (int)1);
        progress.subTask(Messages.ToBeBuiltComputer_CollectingReosurces);
        final ToBeBuilt toBeBuilt = this.doRemoveProject(project, (IProgressMonitor)progress.newChild(1));
        if (!project.isAccessible()) {
            return toBeBuilt;
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (resource instanceof IStorage) {
                    return ToBeBuiltComputer.this.updateStorage(null, toBeBuilt, (IStorage)resource);
                }
                if (resource instanceof IFolder) {
                    return ToBeBuiltComputer.this.isHandled((IFolder)resource);
                }
                return true;
            }
        });
        return toBeBuilt;
    }

    public boolean updateStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeUpdated().add(uri);
        }
        return true;
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeDeleted().add(uri);
        }
        return true;
    }

    protected boolean isHandled(IStorage resource) {
        return resource instanceof IFile;
    }

    protected boolean isHandled(IFolder folder) {
        return true;
    }

    protected URI getUri(IStorage file) {
        URI uri = this.mapper.getUri(file);
        return uri != null && this.isValid(uri, file) ? uri : null;
    }

    protected boolean isValid(URI uri, IStorage storage) {
        return this.uriValidator.canBuild(uri, storage);
    }

    protected IStorage2UriMapper getMapper() {
        return this.mapper;
    }
}

