/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.ICaseInsensitivityHelper;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ICompositeModification;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IMultiModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.AbstractDeclarativeQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.ISimilarityMatcher;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.Messages;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class DefaultQuickfixProvider
extends AbstractDeclarativeQuickfixProvider {
    private static final Logger logger = Logger.getLogger(DefaultQuickfixProvider.class);
    @Inject
    private ISimilarityMatcher similarityMatcher;
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private ICaseInsensitivityHelper caseInsensitivityHelper;
    @Inject
    private CrossRefResolutionConverter converter;
    @Inject
    private OperationCanceledManager cancelManager;

    private CrossReference findCrossReference(EObject context, INode node) {
        if (node == null || node.hasDirectSemanticElement() && context.equals(node.getSemanticElement())) {
            return null;
        }
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof CrossReference) {
            return (CrossReference)grammarElement;
        }
        return this.findCrossReference(context, (INode)node.getParent());
    }

    public List<IssueResolution> getResolutionsForLinkingIssue(Issue issue) {
        IssueResolutionAcceptor issueResolutionAcceptor = (IssueResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
        this.createLinkingIssueResolutions(issue, issueResolutionAcceptor);
        return issueResolutionAcceptor.getIssueResolutions();
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.modificationContextFactory.createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument == null) {
            return;
        }
        xtextDocument.tryReadOnly((IUnitOfWork)new CancelableUnitOfWork<Void, XtextResource>(){
            IssueResolutionAcceptor myAcceptor = null;

            public Void exec(XtextResource state, CancelIndicator cancelIndicator) throws Exception {
                this.myAcceptor = DefaultQuickfixProvider.this.getCancelableAcceptor(issueResolutionAcceptor, cancelIndicator);
                EObject target = state.getEObject(issue.getUriToProblem().fragment());
                EReference reference = DefaultQuickfixProvider.this.getUnresolvedEReference(issue, target);
                if (reference == null) {
                    return null;
                }
                this.fixUnresolvedReference(issue, xtextDocument, target, reference);
                return null;
            }

            protected void fixUnresolvedReference(Issue issue2, IXtextDocument xtextDocument2, EObject target, EReference reference) throws BadLocationException {
                boolean caseInsensitive = DefaultQuickfixProvider.this.caseInsensitivityHelper.isIgnoreCase(reference);
                AbstractElement crossReferenceTerminal = this.getCrossReference(issue2, target);
                String ruleName = null;
                Keyword keyword = null;
                if (crossReferenceTerminal instanceof RuleCall) {
                    RuleCall ruleCall = (RuleCall)crossReferenceTerminal;
                    ruleName = ruleCall.getRule().getName();
                } else if (crossReferenceTerminal instanceof Keyword) {
                    keyword = (Keyword)crossReferenceTerminal;
                }
                String issueString = xtextDocument2.get(issue2.getOffset(), issue2.getLength());
                IScope scope = DefaultQuickfixProvider.this.scopeProvider.getScope(target, reference);
                ArrayList discardedDescriptions = Lists.newArrayList();
                HashSet qualifiedNames = Sets.newHashSet();
                int addedDescriptions = 0;
                int checkedDescriptions = 0;
                for (IEObjectDescription referableElement : DefaultQuickfixProvider.this.queryScope(scope)) {
                    String referableElementQualifiedName = DefaultQuickfixProvider.this.qualifiedNameConverter.toString(referableElement.getQualifiedName());
                    if (DefaultQuickfixProvider.this.similarityMatcher.isSimilar(issueString, DefaultQuickfixProvider.this.qualifiedNameConverter.toString(referableElement.getName()))) {
                        ++addedDescriptions;
                        this.createResolution(issueString, referableElement, ruleName, keyword, caseInsensitive);
                        qualifiedNames.add(referableElementQualifiedName);
                    } else if (qualifiedNames.add(referableElementQualifiedName)) {
                        discardedDescriptions.add(referableElement);
                    }
                    if (++checkedDescriptions > 100) break;
                }
                if (discardedDescriptions.size() + addedDescriptions <= 5) {
                    for (IEObjectDescription referableElement : discardedDescriptions) {
                        this.createResolution(issueString, referableElement, ruleName, keyword, caseInsensitive);
                    }
                }
            }

            protected AbstractElement getCrossReference(Issue issue2, EObject target) {
                ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                if (node == null) {
                    throw new IllegalStateException("Cannot happen since we found a reference");
                }
                ICompositeNode rootNode = node.getRootNode();
                ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)issue2.getOffset());
                CrossReference crossReference = DefaultQuickfixProvider.this.findCrossReference(target, (INode)leaf);
                return crossReference.getTerminal();
            }

            public void createResolution(String issueString, IEObjectDescription solution, String ruleName, Keyword keyword, boolean caseInsensitive) {
                String replacement = DefaultQuickfixProvider.this.qualifiedNameConverter.toString(solution.getName());
                String replaceLabel = DefaultQuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
                if (keyword != null) {
                    if (caseInsensitive && !replacement.equalsIgnoreCase(keyword.getValue())) {
                        return;
                    }
                    if (!caseInsensitive && !replacement.equals(keyword.getValue())) {
                        return;
                    }
                } else if (ruleName != null) {
                    if ((replacement = DefaultQuickfixProvider.this.converter.convertToString(replacement, ruleName)) == null) {
                        return;
                    }
                } else {
                    logger.error((Object)"either keyword or ruleName have to present", (Throwable)new IllegalStateException());
                }
                this.myAcceptor.accept(issue, replaceLabel, replaceLabel, DefaultQuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), new ReplaceModification(issue, replacement));
            }
        });
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope) {
        return scope.getAllElements();
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)target);
        if (node == null) {
            return null;
        }
        ICompositeNode rootNode = node.getRootNode();
        ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)issue.getOffset());
        CrossReference crossReference = this.findCrossReference(target, (INode)leaf);
        if (crossReference != null) {
            return GrammarUtil.getReference((CrossReference)crossReference, (EClass)target.eClass());
        }
        return null;
    }

    protected String fixCrossReferenceLabel(String issueString, String replacement) {
        return Messages.DefaultQuickfixProvider_changeTo + replacement + Messages.DefaultQuickfixProvider_1;
    }

    protected String fixCrossReferenceImage(String issueString, String replacement) {
        return "";
    }

    @Override
    public List<IssueResolution> getResolutions(Issue issue) {
        StopWatch stopWatch = new StopWatch(logger);
        try {
            if ("org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issue.getCode())) {
                ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
                result.addAll(this.getResolutionsForLinkingIssue(issue));
                result.addAll(super.getResolutions(issue));
                ArrayList<IssueResolution> arrayList = result;
                return arrayList;
            }
            List<IssueResolution> list = super.getResolutions(issue);
            return list;
        }
        finally {
            stopWatch.resetAndLog("#getResolutions");
        }
    }

    @Override
    public boolean hasResolutionFor(String issueCode) {
        return "org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issueCode) || super.hasResolutionFor(issueCode);
    }

    protected IssueModificationContext.Factory getModificationContextFactory() {
        return this.modificationContextFactory;
    }

    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    protected ISimilarityMatcher getSimilarityMatcher() {
        return this.similarityMatcher;
    }

    protected OperationCanceledManager getCancelManager() {
        return this.cancelManager;
    }

    protected IssueResolutionAcceptor getCancelableAcceptor(IssueResolutionAcceptor issueResolutionAcceptor, CancelIndicator cancelIndicator) {
        if (this.getCancelManager() != null) {
            return new CancelableResolutionAcceptor(issueResolutionAcceptor, cancelIndicator, this.getCancelManager());
        }
        return issueResolutionAcceptor;
    }

    protected static class CancelableResolutionAcceptor
    extends IssueResolutionAcceptor {
        private CancelIndicator monitor;
        private IssueResolutionAcceptor delegate;
        private OperationCanceledManager manager;

        public CancelableResolutionAcceptor(IssueResolutionAcceptor delegate, CancelIndicator monitor, OperationCanceledManager manager) {
            super(null);
            this.delegate = delegate;
            this.monitor = monitor;
            this.manager = manager;
        }

        @Override
        public void accept(Issue issue, String label, String description, String image, IModification modification) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.accept(issue, label, description, image, modification);
        }

        @Override
        public void accept(Issue issue, String label, String description, String image, ISemanticModification semanticModification) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.accept(issue, label, description, image, semanticModification);
        }

        @Override
        public void accept(Issue issue, String label, String description, String image, IModification modification, int relevance) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.accept(issue, label, description, image, modification, relevance);
        }

        @Override
        public void accept(Issue issue, String label, String description, String image, ISemanticModification semanticModification, int relevance) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.accept(issue, label, description, image, semanticModification, relevance);
        }

        @Override
        public <T extends EObject> void acceptMulti(Issue issue, String label, String description, String image, ICompositeModification<T> modification) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.acceptMulti(issue, label, description, image, modification);
        }

        @Override
        public <T extends EObject> void acceptMulti(Issue issue, String label, String description, String image, ICompositeModification<T> modification, int relevance) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.acceptMulti(issue, label, description, image, modification, relevance);
        }

        @Override
        public <T extends EObject> void acceptMulti(Issue issue, String label, String description, String image, IMultiModification<T> modification) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.acceptMulti(issue, label, description, image, modification);
        }

        @Override
        public <T extends EObject> void acceptMulti(Issue issue, String label, String description, String image, IMultiModification<T> modification, int relevance) {
            this.manager.checkCanceled(this.monitor);
            this.delegate.acceptMulti(issue, label, description, image, modification, relevance);
        }

        @Override
        public List<IssueResolution> getIssueResolutions() {
            return this.delegate.getIssueResolutions();
        }
    }

    public static class CrossRefResolutionConverter {
        @Inject
        private IValueConverterService valueConverter;

        public String convertToString(String replacement, String ruleName) {
            try {
                return this.valueConverter.toString((Object)replacement, ruleName);
            }
            catch (ValueConverterException e) {
                return null;
            }
        }
    }
}

