/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.RawTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

public abstract class AbstractResolvedFeature<T extends JvmFeature>
implements IResolvedFeature {
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping;
    private final LightweightTypeReference contextType;
    private final T declaration;

    public AbstractResolvedFeature(T declaration, LightweightTypeReference contextType) {
        this.contextType = contextType;
        this.declaration = declaration;
    }

    public T getDeclaration() {
        return this.declaration;
    }

    @Override
    public LightweightTypeReference getContextType() {
        return this.contextType;
    }

    @Override
    public LightweightTypeReference getResolvedDeclarator() {
        T declaration = this.getDeclaration();
        JvmDeclaredType declarator = declaration.getDeclaringType();
        return this.getContextType().getSuperType((JvmType)declarator);
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getContextTypeParameterMapping() {
        if (this.typeParameterMapping != null) {
            return this.typeParameterMapping;
        }
        this.typeParameterMapping = Collections.unmodifiableMap(this.computeContextTypeParameterMapping());
        return this.typeParameterMapping;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> computeContextTypeParameterMapping() {
        if (this.getDeclaration().isStatic() && !(this.getDeclaration() instanceof JvmConstructor)) {
            return Collections.emptyMap();
        }
        return new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.getContextType());
    }

    protected LightweightTypeReference getResolvedReference(JvmTypeReference unresolved) {
        ITypeReferenceOwner owner = this.getContextType().getOwner();
        if (unresolved == null) {
            return owner.newReferenceToObject();
        }
        LightweightTypeReference unresolvedLightweight = owner.toLightweightTypeReference(unresolved);
        if (unresolvedLightweight.isPrimitive() || unresolvedLightweight.isPrimitiveVoid()) {
            return unresolvedLightweight;
        }
        TypeParameterSubstitutor<?> substitutor = this.getSubstitutor();
        LightweightTypeReference result = substitutor.substitute(unresolvedLightweight);
        return result;
    }

    protected List<LightweightTypeReference> getResolvedReferences(List<JvmTypeReference> unresolved) {
        ArrayList result = Lists.newArrayListWithCapacity((int)unresolved.size());
        for (JvmTypeReference resolveMe : unresolved) {
            result.add(this.getResolvedReference(resolveMe));
        }
        return result;
    }

    protected boolean isResolvedTypeParameter(JvmTypeParameter typeParameter) {
        return this.isResolvedTypeParameter(this.getContextType(), typeParameter);
    }

    protected boolean isResolvedTypeParameter(LightweightTypeReference typeReference, JvmTypeParameter typeParameter) {
        List<LightweightTypeReference> typeArguments = typeReference.getTypeArguments();
        int size = typeArguments.size();
        for (int i = 0; i < size; ++i) {
            LightweightTypeReference typeArgument = typeArguments.get(i);
            if (!typeParameter.equals(typeArgument.getType()) && !this.isResolvedTypeParameter(typeArgument, typeParameter)) continue;
            return true;
        }
        LightweightTypeReference outer = typeReference.getOuter();
        return outer != null && this.isResolvedTypeParameter(outer, typeParameter);
    }

    protected TypeParameterSubstitutor<?> getSubstitutor() {
        if (this.getContextType().getType() != this.getDeclaration().getDeclaringType() && this.isRawTypeInheritance()) {
            return new RawTypeSubstitutor(this.getContextType().getOwner());
        }
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = this.getContextTypeParameterMapping();
        TypeParameterByConstraintSubstitutor result = new TypeParameterByConstraintSubstitutor(mapping, this.getContextType().getOwner()){

            @Override
            protected boolean isDeclaredTypeParameter(JvmTypeParameter typeParameter) {
                return super.isDeclaredTypeParameter(typeParameter) || AbstractResolvedFeature.this.isResolvedTypeParameter(typeParameter) || this.getTypeParameterMapping().containsKey(typeParameter);
            }

            @Override
            protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter type, ConstraintVisitingInfo info) {
                LightweightMergedBoundTypeArgument result = super.getBoundTypeArgument(type, info);
                if (result != null && result.getTypeReference().getType() == type) {
                    return null;
                }
                return result;
            }
        };
        return result;
    }

    protected boolean isRawTypeInheritance() {
        List<LightweightTypeReference> superTypes = this.getContextType().getAllSuperTypes();
        JvmDeclaredType declaringType = this.getDeclaration().getDeclaringType();
        for (LightweightTypeReference superType : superTypes) {
            if (superType.getType() != declaringType || !superType.isRawType()) continue;
            return true;
        }
        return false;
    }
}

