/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.inject.Inject;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.XtextNewProjectWizard;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.Activator;
import org.eclipse.xtext.xtext.ui.wizard.project.AdvancedNewProjectPage;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.WizardNewXtextProjectCreationPage;
import org.eclipse.xtext.xtext.ui.wizard.project.XtextProjectInfo;
import org.eclipse.xtext.xtext.wizard.BuildSystem;
import org.eclipse.xtext.xtext.wizard.LanguageDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectLayout;
import org.eclipse.xtext.xtext.wizard.TestedProjectDescriptor;

public class NewXtextProjectWizard
extends XtextNewProjectWizard {
    private WizardNewXtextProjectCreationPage mainPage;
    private AdvancedNewProjectPage advancedPage;

    @Inject
    public NewXtextProjectWizard(IProjectCreator projectCreator) {
        super(projectCreator);
        this.setWindowTitle(Messages.NewXtextProjectWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("icons/wizban/newxprj_wiz.gif"));
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewXtextProjectCreationPage("mainPage", this.selection);
        this.advancedPage = new AdvancedNewProjectPage("advancedPage");
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.advancedPage);
    }

    protected IProjectInfo getProjectInfo() {
        XtextProjectInfo projectInfo = this.createProjectInfo();
        LanguageDescriptor language = projectInfo.getLanguage();
        language.setFileExtensions(LanguageDescriptor.FileExtensions.fromString((String)this.mainPage.getFileExtensions()));
        language.setName(this.mainPage.getLanguageName());
        projectInfo.setBaseName(this.mainPage.getProjectName());
        projectInfo.setWorkingSets(Arrays.asList(this.mainPage.getSelectedWorkingSets()));
        projectInfo.setRootLocation(this.mainPage.getLocationPath().toString());
        Charset encoding = null;
        try {
            encoding = Charset.forName(ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset());
        }
        catch (CoreException e) {
            encoding = Charset.defaultCharset();
        }
        projectInfo.setEncoding(encoding);
        String lineDelimiter = InstanceScope.INSTANCE.getNode("org.eclipse.core.runtime").get("line.separator", Strings.newLine());
        projectInfo.setLineDelimiter(lineDelimiter);
        projectInfo.setWorkbench(this.getWorkbench());
        JavaVersion selectedBree = this.mainPage.getJavaVersion();
        if (selectedBree != null) {
            projectInfo.setJavaVersion(selectedBree);
        }
        BuildSystem buildSystem = this.advancedPage.getPreferredBuildSystem();
        projectInfo.setPreferredBuildSystem(buildSystem);
        projectInfo.setSourceLayout(this.advancedPage.getSourceLayout());
        projectInfo.getUiProject().setEnabled(this.advancedPage.isCreateUiProject());
        if (buildSystem != BuildSystem.NONE) {
            projectInfo.setProjectLayout(ProjectLayout.HIERARCHICAL);
        }
        projectInfo.getIdeProject().setEnabled(this.advancedPage.isCreateIdeProject());
        projectInfo.getIntellijProject().setEnabled(this.advancedPage.isCreateIntellijProject());
        projectInfo.getWebProject().setEnabled(this.advancedPage.isCreateWebProject());
        projectInfo.getSdkProject().setEnabled(this.advancedPage.isCreateSdkProject());
        projectInfo.getP2Project().setEnabled(this.advancedPage.isCreateP2Project());
        if (this.advancedPage.isCreateTestProject()) {
            for (ProjectDescriptor project : projectInfo.getEnabledProjects()) {
                if (!(project instanceof TestedProjectDescriptor)) continue;
                ((TestedProjectDescriptor)project).getTestProject().setEnabled(true);
            }
        }
        return projectInfo;
    }

    protected XtextProjectInfo createProjectInfo() {
        return new XtextProjectInfo();
    }
}

