/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.refactoring.IChangeRedirector;
import org.eclipse.xtext.ui.refactoring.impl.AbstractProcessorBasedRenameParticipant;
import org.eclipse.xtext.ui.refactoring.ui.IRenameContextFactory;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.Strings;

public class XtendFileRenameParticipant
extends AbstractProcessorBasedRenameParticipant {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IRenameContextFactory renameContextFactory;

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        if (super.getNewName().endsWith(".xtend")) {
            URI resourceURI;
            ResourceSet resourceSet;
            Resource resource;
            IFile file = (IFile)element;
            final IPath filePath = file.getFullPath();
            final IPath newPath = file.getFullPath().removeLastSegments(1).append(String.valueOf(this.getNewName()) + ".xtend");
            String className = this.trimFileExtension(file.getName());
            if (className != null && (resource = (resourceSet = this.resourceSetProvider.get(file.getProject())).getResource(resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)) != null && !resource.getContents().isEmpty()) {
                for (XtendTypeDeclaration type : EcoreUtil2.eAllOfType((EObject)((EObject)resource.getContents().get(0)), XtendTypeDeclaration.class)) {
                    if (!Strings.equal((String)className, (String)type.getName())) continue;
                    IRenameElementContext renameElementContext = this.renameContextFactory.createRenameElementContext((EObject)type, null, null, (XtextResource)resource);
                    if (renameElementContext instanceof IChangeRedirector.Aware) {
                        ((IChangeRedirector.Aware)renameElementContext).setChangeRedirector(new IChangeRedirector(){

                            public IPath getRedirectedPath(IPath source) {
                                return source.equals((Object)filePath) ? newPath : source;
                            }
                        });
                    }
                    return Collections.singletonList(renameElementContext);
                }
            }
        }
        return super.createRenameElementContexts(element);
    }

    protected String getNewName() {
        return this.trimFileExtension(super.getNewName());
    }

    protected String trimFileExtension(String fileName) {
        if (fileName.lastIndexOf(46) == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    protected List<EObject> getRenamedElementsOrProxies(EObject originalTarget) {
        return Collections.singletonList(originalTarget);
    }
}

