/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.preferences;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class MapBasedPreferenceValues
implements ITypedPreferenceValues,
IPreferenceValuesProvider {
    private final IPreferenceValues delegate;
    private final Map<String, String> values;

    public MapBasedPreferenceValues(IPreferenceValues delegate, Map<String, String> values) {
        this.delegate = delegate;
        this.values = values;
    }

    public MapBasedPreferenceValues(Map<String, String> values) {
        this(null, values);
    }

    public MapBasedPreferenceValues() {
        this(null, Maps.newLinkedHashMap());
    }

    public void clear() {
        this.values.clear();
    }

    public IPreferenceValues getDelegate() {
        return this.delegate;
    }

    @Override
    public String getPreference(PreferenceKey key) {
        String value = this.values.get(key.getId());
        if (value != null) {
            return value;
        }
        if (this.delegate != null) {
            return this.delegate.getPreference(key);
        }
        return key.getDefaultValue();
    }

    @Override
    public <T> T getPreference(TypedPreferenceKey<T> key) {
        String string = this.getPreference((PreferenceKey)key);
        T result = key.toValue(string);
        return result;
    }

    @Override
    public IPreferenceValues getPreferenceValues(Resource context) {
        return this;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void put(PreferenceKey key, Object value) {
        this.put(key.getId(), value.toString());
    }

    public void put(String key, String value) {
        this.values.put(key, value);
    }

    public <T> void put(TypedPreferenceKey<T> key, T value) {
        this.put(key.getId(), key.toString(value));
    }

    public String toString() {
        return this.values.toString();
    }
}

