/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend.ide.refactoring.ExtractMethodRefactoring;
import org.eclipse.xtend.ide.refactoring.ExtractMethodWizard;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.DefaultRenameElementHandler;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringWizardOpenOperation_NonForking;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.RefactoredResourceCopier;

public class ExtractMethodHandler
extends AbstractHandler {
    private static final Logger LOG = Logger.getLogger(DefaultRenameElementHandler.class);
    @Inject
    private SyncUtil syncUtil;
    @Inject
    private ExpressionUtil expressionUtil;
    @Inject
    private Provider<ExtractMethodRefactoring> refactoringProvider;
    @Inject
    private ExtractMethodWizard.Factory wizardFactory;
    @Inject
    private RefactoredResourceCopier resourceCopier;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.syncUtil.totalSync(false);
            XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                ExtractMethodRefactoring extractMethodRefactoring;
                ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IXtextDocument document = editor.getDocument();
                XtextResource copiedResource = (XtextResource)document.priorityReadOnly((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                    public XtextResource exec(XtextResource state) throws Exception {
                        return ExtractMethodHandler.this.resourceCopier.loadIntoNewResourceSet(state);
                    }
                });
                List expressions = this.expressionUtil.findSelectedSiblingExpressions(copiedResource, selection);
                if (!expressions.isEmpty() && (extractMethodRefactoring = (ExtractMethodRefactoring)((Object)this.refactoringProvider.get())).initialize(editor, expressions, true)) {
                    this.updateSelection(editor, expressions);
                    ExtractMethodWizard wizard = this.wizardFactory.create(extractMethodRefactoring);
                    RefactoringWizardOpenOperation_NonForking openOperation = new RefactoringWizardOpenOperation_NonForking((RefactoringWizard)wizard);
                    openOperation.run(editor.getSite().getShell(), "Extract Method");
                }
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Exception exc) {
            LOG.error((Object)"Error during refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error during refactoring", (String)(String.valueOf(exc.getMessage()) + "\nSee log for details"));
        }
        return null;
    }

    protected void updateSelection(XtextEditor editor, List<XExpression> expressions) {
        ICompositeNode firstNode = NodeModelUtils.getNode((EObject)((EObject)expressions.get(0)));
        ICompositeNode lastNode = NodeModelUtils.getNode((EObject)((EObject)expressions.get(expressions.size() - 1)));
        if (firstNode != null && lastNode != null) {
            int correctedSelectionOffset = firstNode.getOffset();
            int correctedSelectionLength = lastNode.getEndOffset() - correctedSelectionOffset;
            editor.selectAndReveal(correctedSelectionOffset, correctedSelectionLength);
        }
    }
}

