/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.LookAheadLineSequence;
import org.eclipse.mylyn.wikitext.util.LocationTrackingReader;

class ContentLineSequence
extends LineSequence.ForwardLineSequence {
    private final LocationTrackingReader reader;
    private Line currentLine;
    private final List<Line> followingLines = new ArrayList<Line>();

    ContentLineSequence(String content) {
        this.reader = new LocationTrackingReader((Reader)new StringReader((String)Preconditions.checkNotNull((Object)content)));
        this.currentLine = this.readLine();
    }

    private Line readLine() {
        String text;
        try {
            text = this.reader.readLine();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (text == null) {
            return null;
        }
        return new Line(this.reader.getLineNumber(), this.reader.getLineOffset(), text);
    }

    @Override
    public Line getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public Line getNextLine() {
        return this.getNextLine(0);
    }

    @Override
    Line getNextLine(int index) {
        Line line;
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        while (this.followingLines.size() <= index && (line = this.readLine()) != null) {
            this.followingLines.add(line);
        }
        if (this.followingLines.size() <= index) {
            return null;
        }
        return this.followingLines.get(index);
    }

    @Override
    public void advance() {
        this.currentLine = this.getNextLine();
        if (this.currentLine != null) {
            this.followingLines.remove(0);
        }
    }

    @Override
    public LineSequence lookAhead() {
        return new LookAheadLineSequence(this);
    }
}

