/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.transformer.jplis;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;

public class ObjectTeamsTransformer
implements ClassFileTransformer {
    private IWeavingContext weavingContext;
    private Set<String> boundBaseClassNames = new HashSet<String>();

    public ObjectTeamsTransformer() {
        this.weavingContext = new IWeavingContext(){

            @Override
            public boolean isWeavable(String className) {
                return ObjectTeamsTransformer.isWeavable(className);
            }
        };
    }

    public ObjectTeamsTransformer(IWeavingContext weavingContext) {
        this.weavingContext = weavingContext;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return this.transform(loader, className, className, classBeingRedefined, classfileBuffer);
    }

    public byte[] transform(ClassLoader loader, String className, String classId, Class<?> classBeingRedefined, byte[] classfileBuffer) {
        AbstractBoundClass clazz;
        block8: {
            if (!ObjectTeamsTransformer.isWeavable(className) || loader == null) {
                return null;
            }
            clazz = ClassRepository.getInstance().getBoundClass(className.replace('/', '.'), classId, loader);
            if (classBeingRedefined == null && !clazz.isFirstTransformation()) {
                return clazz.getBytecode();
            }
            if (!clazz.isTransformationActive()) break block8;
            return null;
        }
        try {
            clazz = ClassRepository.getInstance().getBoundClass(className, classId, classfileBuffer, loader);
            if (!clazz.isInterface()) {
                ClassRepository.getInstance().linkClassWithSuperclass(clazz);
            }
            if (!clazz.isInterface() || clazz.isRole()) {
                clazz.transformAtLoadTime(this.weavingContext);
            }
            classfileBuffer = clazz.getBytecode();
            clazz.dump(classfileBuffer, "initial");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Collection<String> boundBaseClasses = clazz.getBoundBaseClasses();
        if (boundBaseClasses != null) {
            this.boundBaseClassNames.addAll(boundBaseClasses);
        }
        return classfileBuffer;
    }

    public static boolean isWeavable(String className) {
        switch (className.charAt(0)) {
            case 'o': {
                if (!className.startsWith("org/eclipse/objectteams/otre") && !className.startsWith("org/objectteams/") && !className.startsWith("org/objectweb/asm")) break;
                return false;
            }
            case 's': {
                if (!className.startsWith("sun/misc")) break;
                return false;
            }
            case 'j': {
                if (!className.equals("java/util/LinkedHashMap$KeyIterator") && !className.startsWith("java/lang") && !className.startsWith("java/util") && !className.startsWith("java/io")) break;
                return false;
            }
            case '$': {
                return false;
            }
        }
        return true;
    }

    public void readOTAttributes(String className, String classId, InputStream inputStream, ClassLoader loader) throws ClassFormatError, IOException {
        Collection<String> boundBaseClasses;
        AbstractBoundClass clazz = ClassRepository.getInstance().getBoundClass(className.replace('/', '.'), classId, loader);
        if (!clazz.isFirstTransformation()) {
            return;
        }
        try {
            if (clazz.isTransformationActive()) {
                return;
            }
            int available = inputStream.available();
            byte[] bytes = new byte[available];
            inputStream.read(bytes);
            clazz = ClassRepository.getInstance().getBoundClass(className, classId, bytes, loader);
            if (!clazz.isInterface()) {
                ClassRepository.getInstance().linkClassWithSuperclass(clazz);
            }
            if (!clazz.isInterface() || clazz.isRole()) {
                clazz.parseBytecode();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if ((boundBaseClasses = clazz.getBoundBaseClasses()) != null) {
            this.boundBaseClassNames.addAll(boundBaseClasses);
        }
    }

    public Collection<String> fetchAdaptedBases() {
        try {
            Set<String> set = this.boundBaseClassNames;
            return set;
        }
        finally {
            this.boundBaseClassNames = new HashSet<String>();
        }
    }
}

