/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerRemover;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class RoleBindingChangedListener
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        HashSet<ICompilationUnit> invalidatedCUs = new HashSet<ICompilationUnit>();
        this.updateCallinMarkers(new IJavaElementDelta[]{event.getDelta()}, invalidatedCUs);
        for (ICompilationUnit cu : invalidatedCUs) {
            OTDTUIPlugin.getDefault().getCallinMarkerCreator().invalidateBase((IJavaElement)cu);
        }
    }

    private void updateCallinMarkers(IJavaElementDelta[] deltas, Set<ICompilationUnit> invalidatedCUs) {
        if (deltas != null) {
            HashSet<Object> invalidatedRoles = new HashSet<Object>();
            HashSet<IMember> addedBaseMembers = new HashSet<IMember>();
            ICompilationUnit curCU = null;
            int idx = 0;
            while (idx < deltas.length) {
                IRoleType roleParent;
                IJavaElement parent;
                IType roleType;
                IOTType otType;
                IJavaElementDelta curDelta = deltas[idx];
                IJavaElement curElem = curDelta.getElement();
                if (curElem instanceof IParent) {
                    this.updateCallinMarkers(curDelta.getAffectedChildren(), invalidatedCUs);
                }
                if (curElem instanceof IType && (curDelta.getKind() == 2 || curDelta.getKind() == 1 || curDelta.getFlags() == 2048) && (otType = OTModelManager.getOTElement((IType)(roleType = (IType)curElem))) != null && otType.isRole() && invalidatedRoles.add(otType)) {
                    this.invalidateRole((IRoleType)otType, roleType);
                }
                if (curElem instanceof IMethod || curElem instanceof IField) {
                    this.handleDeltaKind(curDelta, (IMember)curElem, addedBaseMembers);
                    curCU = ((IMember)curElem).getCompilationUnit();
                }
                if (curElem instanceof IMethodMapping && (parent = curElem.getParent()) instanceof IRoleType && invalidatedRoles.add(roleParent = (IRoleType)parent)) {
                    this.invalidateRole(roleParent, (IType)roleParent.getCorrespondingJavaElement());
                }
                ++idx;
            }
            if (!addedBaseMembers.isEmpty()) {
                if (addedBaseMembers.size() < 3 && !invalidatedCUs.contains(curCU)) {
                    for (IMember baseMember : addedBaseMembers) {
                        this.baseMemberAdded(baseMember);
                    }
                } else {
                    invalidatedCUs.add(curCU);
                }
            }
        }
    }

    private void invalidateRole(IRoleType otType, IType roleType) {
        IType baseClass = null;
        try {
            baseClass = otType.getBaseClass();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        OTDTUIPlugin.getDefault().getCallinMarkerCreator().invalidateRole(roleType, baseClass);
    }

    private void handleDeltaKind(IJavaElementDelta delta, IMember baseMember, Set<IMember> addedBaseMembers) {
        if (delta.getKind() == 1) {
            addedBaseMembers.add(baseMember);
        } else if (delta.getKind() == 2) {
            this.baseMemberRemoved(baseMember, baseMember.getResource());
        }
    }

    private void baseMemberAdded(IMember baseMember) {
        IWorkbenchPartSite site;
        IStatusLineManager statusLine = null;
        IWorkbenchPage page = OTDTUIPlugin.getActivePage();
        if (page != null && page.getActivePart() != null && (site = page.getActivePart().getSite()) instanceof IViewSite) {
            statusLine = ((IViewSite)site).getActionBars().getStatusLineManager();
        }
        OTDTUIPlugin.getDefault().getCallinMarkerCreator().updateCallinMarker(baseMember, statusLine);
    }

    private void baseMemberRemoved(IMember baseMember, IResource resource) {
        CallinMarkerRemover.removeCallinMarker(baseMember, resource);
    }
}

