/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.util.OS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Request
extends HashMap<String, String> {
    private static final URI DEFAULT_URI = URI.createURI((String)"about:");
    private static final long serialVersionUID = 1L;
    private transient URI uri;

    public Request() {
    }

    public Request(String uri) {
        this(uri == null ? null : URI.createURI((String)uri));
    }

    public Request(URI uri) {
        this.setURI(uri);
    }

    public Request(Request source) {
        this(source.getURI());
    }

    public URI getURI() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (builder.length() != 0) {
                builder.append("&");
            }
            builder.append((String)entry.getKey());
            String value = (String)entry.getValue();
            if (value == null) continue;
            builder.append("=");
            builder.append(URI.encodeQuery((String)value, (boolean)false));
        }
        return this.uri.appendQuery(builder.toString());
    }

    public void setURI(URI uri) {
        if (uri == null) {
            uri = DEFAULT_URI;
        }
        this.clear();
        String query = uri.query();
        if (query != null) {
            String[] parameters;
            String[] stringArray = parameters = query.split("&");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    this.put(parameter, null);
                } else {
                    String key = parameter.substring(0, pos);
                    String value = URI.decode((String)parameter.substring(pos + 1));
                    this.put(key, value);
                }
                ++n2;
            }
            uri = uri.trimQuery();
        }
        this.uri = uri;
    }

    public Request copy() {
        return new Request(this);
    }

    @Override
    public int hashCode() {
        return this.getURI().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        return this.getURI().equals(other.getURI());
    }

    @Override
    public String toString() {
        return this.getURI().toString();
    }

    public static interface Handler {
        public static final Handler SYSTEM_BROWSER = new Handler(){

            public boolean handleRequest(Request request) {
                return OS.INSTANCE.openSystemBrowser(request.getURI().toString());
            }
        };

        public boolean handleRequest(Request var1);

        public static abstract class Modifier
        implements Handler {
            private final Handler delegate;

            public Modifier(Handler delegate) {
                this.delegate = delegate;
            }

            public boolean handleRequest(Request request) {
                request = request.copy();
                this.modify(request);
                return this.delegate.handleRequest(request);
            }

            protected abstract void modify(Request var1);
        }
    }
}

