/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.util.IOUtil;

public class Snapshot {
    private final DataProvider dataProvider;
    private final File oldFile;
    private final File newFile;
    private final File tmpFile;

    public Snapshot(DataProvider dataProvider, File folder) {
        this.dataProvider = dataProvider;
        String prefix = dataProvider.getLocation().toString().toLowerCase();
        this.oldFile = new File(folder, String.valueOf(prefix) + "-old.xml");
        this.newFile = new File(folder, String.valueOf(prefix) + "-new.xml");
        this.tmpFile = new File(folder, String.valueOf(prefix) + "-tmp.xml");
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public File getFolder() {
        return this.tmpFile.getParentFile();
    }

    public File getOldFile() {
        return this.oldFile;
    }

    public File getNewFile() {
        return this.newFile;
    }

    public WorkingCopy createWorkingCopy() throws IOException {
        try {
            this.dataProvider.update(this.newFile);
        }
        catch (DataProvider.NotFoundException notFoundException) {
            SyncUtil.deleteFile(this.newFile);
        }
        return new WorkingCopy(this);
    }

    private void doCommit() throws IOException, DataProvider.NotCurrentException {
        if (!this.tmpFile.isFile()) {
            throw new FileNotFoundException(this.tmpFile.getAbsolutePath());
        }
        try {
            String baseVersion = SyncUtil.getDigest(this.newFile);
            this.dataProvider.post(this.tmpFile, baseVersion);
            this.moveTmpFileTo(this.oldFile);
            IOUtil.copyFile((File)this.oldFile, (File)this.newFile);
        }
        catch (DataProvider.NotCurrentException ex) {
            this.moveTmpFileTo(this.newFile);
            throw ex;
        }
    }

    private void moveTmpFileTo(File target) throws IOException {
        SyncUtil.deleteFile(target);
        if (!this.tmpFile.renameTo(target)) {
            throw new IOException("Could not rename " + this.tmpFile + " to " + target);
        }
    }

    public static final class WorkingCopy {
        private final Snapshot snapshot;
        private boolean committed;
        private boolean disposed;

        private WorkingCopy(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean isLocal() {
            return this.snapshot.getDataProvider().getLocation() == DataProvider.Location.LOCAL;
        }

        public File getTmpFile() {
            return this.snapshot.tmpFile;
        }

        public void commit() throws IOException, DataProvider.NotCurrentException {
            if (!this.committed && !this.disposed) {
                this.committed = true;
                this.snapshot.doCommit();
            }
        }

        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                try {
                    SyncUtil.deleteFile(this.snapshot.tmpFile);
                }
                catch (Throwable ex) {
                    SetupSyncPlugin.INSTANCE.log(ex);
                }
            }
        }
    }
}

