/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.util.ProjectConfigUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfigURIHandlerImpl
extends URIHandlerImpl {
    public boolean canHandle(URI uri) {
        return "configuration".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.segmentCount() == 1) {
            class ProjectConfigInput
            extends InputStream
            implements URIConverter.Loadable {
                private InputStream in;

                ProjectConfigInput() {
                }

                public void loadResource(Resource resource) throws IOException {
                    resource.getContents().addAll((Collection)ProjectConfigUtil.getWorkspaceConfiguration().eResource().getContents());
                }

                public int read() throws IOException {
                    if (this.in == null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ProjectConfigUtil.getWorkspaceConfiguration().eResource().save((OutputStream)out, null);
                        this.in = new ByteArrayInputStream(out.toByteArray());
                    }
                    return this.in.read();
                }
            }
            return new ProjectConfigInput();
        }
        throw new IOException("No preference value available for ");
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.segmentCount() == 1) {
            class ProjectConfigOutput
            extends OutputStream
            implements URIConverter.Saveable {
                ProjectConfigOutput() {
                }

                public void saveResource(Resource resource) throws IOException {
                    try {
                        ProjectConfigUtil.saveWorkspaceConfiguration((WorkspaceConfiguration)resource.getContents().get(0));
                    }
                    catch (BackingStoreException ex) {
                        throw new IOExceptionWithCause((Throwable)ex);
                    }
                }

                public void write(int b) throws IOException {
                    throw new IOException("Write not supported");
                }
            }
            return new ProjectConfigOutput();
        }
        throw new IOException("Output not supported");
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("Delete not supported");
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return false;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

