/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.SynchronizerCredentials;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;

public final class SynchronizerService {
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private final String label;
    private final URI serviceURI;
    private final URI signupURI;

    public SynchronizerService(String label, URI serviceURI, URI signupURI) {
        this.label = label;
        this.serviceURI = serviceURI;
        this.signupURI = signupURI;
    }

    public String getLabel() {
        return this.label;
    }

    public URI getServiceURI() {
        return this.serviceURI;
    }

    public URI getSignupURI() {
        return this.signupURI;
    }

    public SynchronizerCredentials getCredentials() {
        try {
            ISecurePreferences securePreferences = this.getPreferences();
            String username = securePreferences.get(USERNAME_KEY, null);
            String password = securePreferences.get(PASSWORD_KEY, null);
            if (username != null && password != null) {
                return new SynchronizerCredentials(username, password);
            }
        }
        catch (StorageException ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
        return null;
    }

    public void setCredentials(SynchronizerCredentials credentials) {
        try {
            ISecurePreferences securePreferences = this.getPreferences();
            if (credentials == null) {
                securePreferences.remove(USERNAME_KEY);
                securePreferences.remove(PASSWORD_KEY);
            } else {
                securePreferences.put(USERNAME_KEY, credentials.getUsername(), true);
                securePreferences.put(PASSWORD_KEY, credentials.getPassword(), true);
                securePreferences.flush();
            }
        }
        catch (Exception ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
    }

    public boolean validateCredentials(SynchronizerCredentials credentials) throws IOException {
        if (credentials == null) {
            return false;
        }
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        RemoteDataProvider remoteDataProvider = new RemoteDataProvider(this.serviceURI, (Credentials)usernamePasswordCredentials);
        Snapshot remoteSnapshot = new Snapshot(remoteDataProvider, this.getSyncFolder());
        File file = remoteSnapshot.getNewFile();
        try {
            remoteDataProvider.update(file);
        }
        catch (RemoteDataProvider.AuthorizationRequiredException authorizationRequiredException) {
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return true;
    }

    public RemoteDataProvider createDataProvider() {
        SynchronizerCredentials credentials = this.getCredentials();
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        return new RemoteDataProvider(this.serviceURI, (Credentials)usernamePasswordCredentials);
    }

    public File getSyncFolder() {
        String serviceNode = this.getServiceNode();
        if (serviceNode == null) {
            return null;
        }
        return SetupSyncPlugin.INSTANCE.getUserLocation().append(serviceNode).toFile();
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.serviceURI);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == SynchronizerService.class) {
            SynchronizerService that = (SynchronizerService)obj;
            return ObjectUtil.equals((Object)this.serviceURI, (Object)that.serviceURI);
        }
        return false;
    }

    public String toString() {
        return this.label;
    }

    private ISecurePreferences getPreferences() {
        String serviceNode = this.getServiceNode();
        if (serviceNode == null) {
            return null;
        }
        return PreferencesUtil.getSecurePreferences().node("org.eclipse.oomph").node("sync").node(serviceNode);
    }

    private String getServiceNode() {
        URI serviceURI = this.getServiceURI();
        if (serviceURI == null) {
            return null;
        }
        return IOUtil.encodeFileName((String)serviceURI.toString());
    }

    public static final class Registry {
        public static final Registry INSTANCE = new Registry();
        public static final SynchronizerService ECLIPSE_SERVICE = new SynchronizerService("Eclipse.org", IOUtil.newURI((String)"https://dev.eclipse.org/oomph"), IOUtil.newURI((String)"https://dev.eclipse.org/site_login"));
        private static final SynchronizerService[] SERVICES = new SynchronizerService[]{ECLIPSE_SERVICE};

        private Registry() {
        }

        public SynchronizerService[] getServices() {
            return SERVICES;
        }

        public SynchronizerService getService(URI serviceURI) {
            int i = 0;
            while (i < SERVICES.length) {
                SynchronizerService service = SERVICES[i];
                if (ObjectUtil.equals((Object)service.getServiceURI(), (Object)serviceURI)) {
                    return service;
                }
                ++i;
            }
            return null;
        }
    }
}

