/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesUtil {
    public static final String CONDITIONAL_EXPERT_FILTER = "org.eclipse.ui.views.properties.expert.conditional";
    public static final String[] EXPERT_FILTER = new String[]{"org.eclipse.ui.views.properties.expert"};
    private static final String TRUE = Boolean.TRUE.toString();

    private PropertiesUtil() {
    }

    public static Boolean getBoolean(String key) {
        String property = PropertiesUtil.getProperty(key);
        if (property != null) {
            return TRUE.equalsIgnoreCase(property);
        }
        return null;
    }

    public static boolean isProperty(String key) {
        String property = PropertiesUtil.getProperty(key);
        if (property != null) {
            return TRUE.equalsIgnoreCase(property);
        }
        return false;
    }

    public static String getProperty(String key) {
        return PropertiesUtil.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null && (value = System.getenv(key)) == null && key.indexOf(46) != -1) {
            key = key.replace('.', '_');
            value = PropertiesUtil.getProperty(key, defaultValue);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static int getProperty(String key, int defaultValue) {
        try {
            String property = PropertiesUtil.getProperty(key);
            return Integer.parseInt(property);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String getUserHome() {
        return PropertiesUtil.getProperty("user.home", ".");
    }

    public static String getTmpDir() {
        return PropertiesUtil.getProperty("java.io.tmpdir", ".");
    }

    public static String getApplicationID() {
        IProduct product;
        String applicationID = PropertiesUtil.getProperty("eclipse.application");
        if (StringUtil.isEmpty(applicationID) && (product = Platform.getProduct()) != null) {
            applicationID = product.getApplication();
        }
        return applicationID;
    }

    public static String getProductID() {
        IProduct product;
        String productID = PropertiesUtil.getProperty("eclipse.product");
        if (StringUtil.isEmpty(productID) && (product = Platform.getProduct()) != null) {
            productID = product.getId();
        }
        return productID;
    }

    public static String getProductName() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getName();
        }
        return "Eclipse";
    }

    public static void saveProperties(File file, Map<String, String> properties, boolean sort) {
        PropertiesUtil.saveProperties(file, properties, sort, false, null);
    }

    public static void saveProperties(File file, final Map<String, String> properties, final boolean sort, boolean withDate, String comment) {
        FileOutputStream stream = null;
        try {
            try {
                File folder = file.getParentFile();
                folder.mkdirs();
                stream = new FileOutputStream(file);
                Properties converter = new Properties(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public synchronized Enumeration<Object> keys() {
                        Collection keys = properties.keySet();
                        if (sort) {
                            ArrayList keyList = new ArrayList(keys);
                            Collections.sort(keyList);
                            keys = keyList;
                        }
                        Vector<String> keyVector = new Vector<String>();
                        for (String key : keys) {
                            keyVector.add(key);
                        }
                        return keyVector.elements();
                    }

                    @Override
                    public synchronized Object get(Object key) {
                        return properties.get(key);
                    }
                };
                if (withDate) {
                    converter.store(stream, comment);
                } else {
                    ByteArrayOutputStream temp = new ByteArrayOutputStream();
                    converter.store(temp, comment);
                    String string = temp.toString("8859_1");
                    int firstNL = string.indexOf(StringUtil.NL);
                    if (firstNL != -1) {
                        if (comment == null) {
                            string = string.substring(firstNL + StringUtil.NL.length());
                        } else {
                            int secondNL = string.indexOf(StringUtil.NL, firstNL + StringUtil.NL.length());
                            String commentLine = string.substring(0, firstNL + StringUtil.NL.length());
                            string = String.valueOf(commentLine) + string.substring(secondNL + StringUtil.NL.length());
                        }
                    }
                    IOUtil.copy(new ByteArrayInputStream(string.getBytes("8859_1")), stream);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(stream);
            throw throwable;
        }
        IOUtil.closeSilent(stream);
    }

    public static Map<String, String> loadProperties(File file) {
        LinkedHashMap<String, String> linkedHashMap;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            final LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            Properties converter = new Properties(){
                private static final long serialVersionUID = 1L;

                public synchronized Object put(Object key, Object value) {
                    return properties.put((String)key, (String)value);
                }
            };
            converter.load(stream);
            linkedHashMap = properties;
        }
        catch (IOException ex) {
            try {
                throw new IORuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(stream);
                throw throwable;
            }
        }
        IOUtil.closeSilent(stream);
        return linkedHashMap;
    }

    public static Map<String, String> getProperties(File file) {
        if (file.isFile()) {
            return PropertiesUtil.loadProperties(file);
        }
        return new LinkedHashMap<String, String>();
    }
}

