/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContextType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewItemProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIReviewItem
extends R4EUIFileContainer {
    public static final String REVIEW_ITEM_ICON_FILE = "icons/obj16/revitm_obj.gif";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Review Item";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Review Item from its Parent Review";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Review Item";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Review Item";

    public R4EUIReviewItem(IR4EUIModelElement aParent, R4EItem aItem, String aName, int aItemType) {
        super(aParent, aItem, aName, aItemType);
    }

    @Override
    public String getImageLocation() {
        return REVIEW_ITEM_ICON_FILE;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ReviewItemProperties(this);
        }
        return null;
    }

    @Override
    public void setUserReviewed(boolean aReviewed, boolean aSetChildren, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        this.fUserReviewed = aReviewed;
        if (this.fUserReviewed) {
            this.getParent().checkToSetUserReviewed(aUpdateModel);
        } else {
            this.getParent().setUserReviewed(this.fUserReviewed, false, aUpdateModel);
        }
        if (aSetChildren) {
            int length = this.fFileContexts.size();
            int i = 0;
            while (i < length) {
                ((R4EUIFileContext)this.fFileContexts.get(i)).setChildUserReviewed(aReviewed, aUpdateModel);
                ++i;
            }
        }
    }

    @Override
    public void checkToSetUserReviewed(boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        boolean allChildrenReviewed = true;
        int length = this.fFileContexts.size();
        int i = 0;
        while (i < length) {
            if (!((R4EUIFileContext)this.fFileContexts.get(i)).isUserReviewed()) {
                allChildrenReviewed = false;
            }
            ++i;
        }
        if (allChildrenReviewed) {
            this.fUserReviewed = true;
            this.getParent().checkToSetUserReviewed(aUpdateModel);
        }
    }

    @Override
    public void addAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fItem, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fItem.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.add((Object)participant.getId());
                ((R4EUIReviewBasic)this.getParent()).getParticipant(participant.getId(), true);
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
        for (R4EUIFileContext file : this.fFileContexts) {
            file.addAssignees(aParticipants);
        }
    }

    @Override
    public void removeAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fItem, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fItem.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.remove((Object)participant.getId());
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
        for (R4EUIFileContext file : this.fFileContexts) {
            file.removeAssignees(aParticipants);
        }
    }

    public int getNumChanges() {
        int numChanges = 0;
        for (R4EUIFileContext file : this.fFileContexts) {
            numChanges += file.getNumChanges();
        }
        return numChanges;
    }

    public int getNumReviewedChanges() {
        int numReviewedChanges = 0;
        for (R4EUIFileContext file : this.fFileContexts) {
            numReviewedChanges += file.getNumReviewedChanges();
        }
        return numReviewedChanges;
    }

    public int getNumAnomalies() {
        int numAnomalies = 0;
        for (R4EUIFileContext file : this.fFileContexts) {
            numAnomalies += file.getNumAnomalies();
        }
        return numAnomalies;
    }

    public R4EUIFileContext createFileContext(R4EFileVersion aBaseTempFileVersion, R4EFileVersion aTargetTempFileVersion, R4EContextType aType) throws ResourceHandlingException, OutOfSyncException {
        String projPlatformURI;
        IFileRevision fileRev;
        IRFSRegistry revRegistry = null;
        try {
            revRegistry = RFSRegistryFactory.getRegistry((R4EReview)((R4EUIReviewBasic)this.getParent()).getReview());
        }
        catch (ReviewsFileStorageException e1) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e1.toString() + " (" + e1.getMessage() + ")");
        }
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fItem, R4EUIModelController.getReviewer());
        R4EFileContext fileContext = R4EUIModelController.FModelExt.createR4EFileContext(this.fItem);
        fileContext.setType(aType);
        if (aBaseTempFileVersion != null) {
            R4EFileVersion rfileBaseVersion = R4EUIModelController.FModelExt.createR4EBaseFileVersion(fileContext);
            CommandUtils.copyFileVersionData(rfileBaseVersion, aBaseTempFileVersion);
            if (revRegistry != null) {
                try {
                    fileRev = revRegistry.getIFileRevision(null, rfileBaseVersion);
                    rfileBaseVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
            if (rfileBaseVersion.getResource() != null) {
                projPlatformURI = ResourceUtils.toPlatformURIStr((IResource)rfileBaseVersion.getResource().getProject());
                if (!this.fItem.getProjectURIs().contains((Object)projPlatformURI)) {
                    this.fItem.getProjectURIs().add((Object)projPlatformURI);
                }
            }
        }
        if (aTargetTempFileVersion != null) {
            R4EFileVersion rfileTargetVersion = R4EUIModelController.FModelExt.createR4ETargetFileVersion(fileContext);
            CommandUtils.copyFileVersionData(rfileTargetVersion, aTargetTempFileVersion);
            if (revRegistry != null) {
                try {
                    fileRev = revRegistry.getIFileRevision(null, rfileTargetVersion);
                    rfileTargetVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
            if (rfileTargetVersion.getResource() != null) {
                projPlatformURI = ResourceUtils.toPlatformURIStr((IResource)rfileTargetVersion.getResource().getProject());
                if (!this.fItem.getProjectURIs().contains((Object)projPlatformURI)) {
                    this.fItem.getProjectURIs().add((Object)projPlatformURI);
                }
            }
        }
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIFileContext uiFile = new R4EUIFileContext(this, fileContext, this.fType);
        this.addChildren(uiFile);
        return uiFile;
    }

    @Override
    public void restore() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        super.restore();
        for (String participant : this.fItem.getAssignedTo()) {
            R4EUIModelController.getActiveReview().getParticipant(participant, true);
        }
        for (R4EFileContext file : this.fItem.getFileContextList()) {
            for (String participant : file.getAssignedTo()) {
                R4EUIModelController.getActiveReview().getParticipant(participant, true);
            }
            for (R4EDelta content : file.getDeltas()) {
                for (String participant : content.getAssignedTo()) {
                    R4EUIModelController.getActiveReview().getParticipant(participant, true);
                }
            }
        }
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)((R4EUIReviewBasic)this.getParent()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isAssigned(String aUsername, boolean aCheckChildren) {
        if (this.fItem.isEnabled()) {
            if (this.fItem.getAssignedTo().contains((Object)aUsername)) {
                return true;
            }
            if (aCheckChildren) {
                for (R4EUIFileContext file : this.fFileContexts) {
                    if (!file.isAssigned(aUsername, aCheckChildren)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isRestoreElementCmd() {
        if (!this.getParent().isEnabled()) {
            return false;
        }
        return !this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)((R4EUIReviewBasic)this.getParent()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isChangeUserReviewStateCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)((R4EUIReviewBasic)this.getParent()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isAssignToCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)((R4EUIReviewBasic)this.getParent()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isUnassignToCmd() {
        if (this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)((R4EUIReviewBasic)this.getParent()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) && this.fItem.getAssignedTo().size() > 0) {
            return true;
        }
        IR4EUIModelElement[] iR4EUIModelElementArray = this.getChildren();
        int n = iR4EUIModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement file = iR4EUIModelElementArray[n2];
            if (file.isUnassignToCmd()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isSendEmailCmd() {
        return this.isEnabled();
    }
}

