/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.TreeTableFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorDecorator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorLabelProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.TreeTableComparator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ReviewNavigatorTreeViewer
extends TreeViewer {
    private static final String REVIEW_COLUMN_LABEL = "Review-> ";
    private static final String REVIEW_GROUP_COLUMN_TOOLTIP = "Group-> ";
    private static final String INVALID_PATH = "--";
    private static final String VERSION_TARGET_LABEL = "Target Version: ";
    private static final String VERSION_BASE_LABEL = "Base Version: ";
    private static final String NUM_CHANGES_ITEM_COLUMN_TOOLTIP = "Number of Reviewed Changes / Number of Changes for this Review Item";
    private static final String NUM_CHANGES_FILE_COLUMN_TOOLTIP = "Number of Changes for this File";
    private static final String NUM_ANOMALIES_COLUMN_TOOLTIP = "Number of Anomalies written for this File";
    private boolean fIsDefaultDisplay = true;
    private Object fDefaultInput = null;
    private TreeColumnLayout fTreeColumnLayout = new TreeColumnLayout();
    ViewerComparator fTreeComparator = null;
    TreeTableComparator fTreeTableComparator = new TreeTableComparator();
    private TreeViewerColumn fElementColumn = null;
    private TreeViewerColumn fPathColumn = null;
    private TreeViewerColumn fAssignColumn = null;
    private TreeViewerColumn fNumChangesColumn = null;
    private TreeViewerColumn fNumAnomaliesColumn = null;
    private int fElementColumnWeight = 25;
    private int fPathColumnWeight = 50;
    private int fAssignColumnWeight = 9;
    private int fNumChangesColumnWeight = 8;
    private int fNumAnomaliesColumnWeight = 8;

    public boolean isDefaultDisplay() {
        return this.fIsDefaultDisplay;
    }

    public void setDefaultInput(Object aInput) {
        this.fDefaultInput = aInput;
    }

    public ReviewNavigatorTreeViewer(Composite aParent, int aStyle) {
        super(aParent, aStyle);
        aParent.setLayout((Layout)this.fTreeColumnLayout);
    }

    public TreeItem getPrevious(TreeItem aItem) {
        TreeItem newItem = (TreeItem)this.getPreviousItem((Item)aItem);
        if (newItem == null) {
            return aItem;
        }
        return newItem;
    }

    public TreeItem getNext(TreeItem aItem) {
        TreeItem newItem = (TreeItem)this.getNextItem((Item)aItem, true);
        if (newItem == null) {
            return aItem;
        }
        return newItem;
    }

    public void setViewTree() {
        Object[] expandedElements = this.getExpandedElements();
        double elementColumnWidth = -1.0;
        double pathColumnWidth = -1.0;
        double assignColumnWidth = -1.0;
        double numChangesColumnWidth = -1.0;
        double numAnomaliesColumnWidth = -1.0;
        if (this.fElementColumn != null) {
            elementColumnWidth = this.fElementColumn.getColumn().getWidth();
        }
        this.createElementsColumn();
        this.getTree().setHeaderVisible(false);
        if (this.fPathColumn != null) {
            pathColumnWidth = this.fPathColumn.getColumn().getWidth();
            this.fPathColumn.getColumn().dispose();
            this.fPathColumn = null;
        }
        if (this.fAssignColumn != null) {
            assignColumnWidth = this.fAssignColumn.getColumn().getWidth();
            this.fAssignColumn.getColumn().dispose();
            this.fAssignColumn = null;
        }
        if (this.fNumChangesColumn != null) {
            numChangesColumnWidth = this.fNumChangesColumn.getColumn().getWidth();
            this.fNumChangesColumn.getColumn().dispose();
            this.fNumChangesColumn = null;
        }
        if (this.fNumAnomaliesColumn != null) {
            numAnomaliesColumnWidth = this.fNumAnomaliesColumn.getColumn().getWidth();
            this.fNumAnomaliesColumn.getColumn().dispose();
            this.fNumAnomaliesColumn = null;
        }
        this.fTreeColumnLayout.setColumnData((Widget)this.fElementColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        if (elementColumnWidth != -1.0 && pathColumnWidth != -1.0 && assignColumnWidth != -1.0 && numChangesColumnWidth != -1.0 && numAnomaliesColumnWidth != -1.0) {
            double totalWidth = elementColumnWidth + pathColumnWidth + assignColumnWidth + numChangesColumnWidth + numAnomaliesColumnWidth;
            this.fElementColumnWeight = (int)(elementColumnWidth / totalWidth * 100.0);
            this.fPathColumnWeight = (int)(pathColumnWidth / totalWidth * 100.0);
            this.fAssignColumnWeight = (int)(assignColumnWidth / totalWidth * 100.0);
            this.fNumChangesColumnWeight = (int)(numChangesColumnWidth / totalWidth * 100.0);
            this.fNumAnomaliesColumnWeight = (int)(numAnomaliesColumnWidth / totalWidth * 100.0);
            this.fElementColumn.getColumn().setWidth((int)totalWidth);
        }
        this.fIsDefaultDisplay = true;
        TreeTableFilter filter = ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).getTreeTableFilter();
        this.removeFilter(filter);
        this.setComparator(this.fTreeComparator);
        this.setInput(this.fDefaultInput);
        ArrayList<Object> updatedExpandedElements = new ArrayList<Object>();
        if (expandedElements.length > 0) {
            if (expandedElements[0] != null && ((IR4EUIModelElement)expandedElements[0]).getParent() != null) {
                updatedExpandedElements.add(((IR4EUIModelElement)expandedElements[0]).getParent());
                if (((IR4EUIModelElement)expandedElements[0]).getParent().getParent() != null) {
                    updatedExpandedElements.add(((IR4EUIModelElement)expandedElements[0]).getParent().getParent());
                }
            }
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object expandedElement = objectArray[n2];
                if (expandedElement != null) {
                    updatedExpandedElements.add(expandedElement);
                }
                ++n2;
            }
        } else {
            R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
            if (activeReview != null) {
                updatedExpandedElements.add(activeReview);
                if (activeReview.getParent() != null) {
                    updatedExpandedElements.add(activeReview.getParent());
                }
            }
        }
        Object[] elementsToExpand = updatedExpandedElements.toArray(new Object[updatedExpandedElements.size()]);
        this.setExpandedElements(elementsToExpand);
    }

    public void setViewTreeTable() {
        Object[] expandedElements = this.getExpandedElements();
        this.createPathColumn();
        this.createAssignmentColumn();
        this.createNumChangesColumn();
        this.createNumAnomaliesColumn();
        this.getTree().setHeaderVisible(true);
        this.fTreeColumnLayout.setColumnData((Widget)this.fElementColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fElementColumnWeight, true));
        this.fTreeColumnLayout.setColumnData((Widget)this.fPathColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fPathColumnWeight, true));
        this.fTreeColumnLayout.setColumnData((Widget)this.fAssignColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fAssignColumnWeight, true));
        this.fTreeColumnLayout.setColumnData((Widget)this.fNumChangesColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fNumChangesColumnWeight, true));
        this.fTreeColumnLayout.setColumnData((Widget)this.fNumAnomaliesColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fNumAnomaliesColumnWeight, true));
        R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
        if (activeReview != null) {
            this.fElementColumn.getColumn().setText(activeReview.getReview().getName());
            this.fElementColumn.getColumn().setToolTipText(REVIEW_GROUP_COLUMN_TOOLTIP + activeReview.getParent().getName() + R4EUIConstants.LINE_FEED + REVIEW_COLUMN_LABEL + activeReview.getName());
        }
        TreeTableFilter filter = ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).getTreeTableFilter();
        this.fIsDefaultDisplay = false;
        this.fDefaultInput = this.getInput();
        if (this.fDefaultInput instanceof R4EUIRootElement || this.fDefaultInput instanceof R4EUIReviewGroup) {
            this.setInput(R4EUIModelController.getActiveReview());
        }
        this.addFilter(filter);
        this.fTreeComparator = this.getComparator();
        this.setComparator(this.fTreeTableComparator);
        this.getTree().getParent().layout();
        this.setExpandedElements(expandedElements);
    }

    public void createElementsColumn() {
        if (this.fElementColumn == null) {
            DecoratingCellLabelProvider provider = new DecoratingCellLabelProvider((ILabelProvider)new ReviewNavigatorLabelProvider(), new ReviewNavigatorDecorator());
            this.fElementColumn = new TreeViewerColumn((TreeViewer)this, 0);
            this.fElementColumn.setLabelProvider((CellLabelProvider)provider);
            this.fElementColumn.getColumn().setMoveable(false);
            this.fElementColumn.getColumn().setResizable(true);
            this.fElementColumn.getColumn().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (!ReviewNavigatorTreeViewer.this.isDefaultDisplay()) {
                        ReviewNavigatorTreeViewer.this.fTreeTableComparator.setColumnName("Elements");
                        ReviewNavigatorTreeViewer.this.getTree().setSortDirection(ReviewNavigatorTreeViewer.this.fTreeTableComparator.getDirection());
                        ReviewNavigatorTreeViewer.this.getTree().setSortColumn(ReviewNavigatorTreeViewer.this.fElementColumn.getColumn());
                        ReviewNavigatorTreeViewer.this.refresh();
                    }
                }
            });
        }
    }

    private void createPathColumn() {
        if (this.fPathColumn == null) {
            this.fPathColumn = new TreeViewerColumn((TreeViewer)this, 0);
            this.fPathColumn.getColumn().setText("Path");
            this.fTreeColumnLayout.setColumnData((Widget)this.fPathColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, true));
            this.fPathColumn.getColumn().setMoveable(true);
            this.fPathColumn.getColumn().setResizable(true);
            this.fPathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object aElement) {
                    if (aElement instanceof R4EUIFileContext) {
                        R4EFileVersion version = ((R4EUIFileContext)aElement).getTargetFileVersion();
                        if (version != null) {
                            return UIUtils.getProjectPath(version);
                        }
                        version = ((R4EUIFileContext)aElement).getBaseFileVersion();
                        if (version != null) {
                            return UIUtils.getProjectPath(version);
                        }
                        return ReviewNavigatorTreeViewer.INVALID_PATH;
                    }
                    return null;
                }

                public String getToolTipText(Object aElement) {
                    StringBuffer buffer = new StringBuffer();
                    if (aElement instanceof R4EUIFileContext) {
                        R4EFileVersion targetVersion = ((R4EUIFileContext)aElement).getTargetFileVersion();
                        R4EFileVersion baseVersion = ((R4EUIFileContext)aElement).getBaseFileVersion();
                        buffer.append("File: ");
                        if (targetVersion != null) {
                            buffer.append(UIUtils.getProjectPath(targetVersion));
                        } else if (baseVersion != null) {
                            buffer.append(UIUtils.getProjectPath(baseVersion));
                        } else {
                            buffer.append(ReviewNavigatorTreeViewer.INVALID_PATH);
                        }
                        buffer.append(R4EUIConstants.LINE_FEED);
                        buffer.append(ReviewNavigatorTreeViewer.VERSION_TARGET_LABEL);
                        if (targetVersion == null) {
                            buffer.append("(Not Present)");
                        } else {
                            buffer.append(targetVersion.getVersionID());
                        }
                        buffer.append(R4EUIConstants.LINE_FEED);
                        buffer.append(ReviewNavigatorTreeViewer.VERSION_BASE_LABEL);
                        if (baseVersion == null) {
                            buffer.append("(Not Present)");
                        } else {
                            buffer.append(baseVersion.getVersionID());
                        }
                        return buffer.toString();
                    }
                    return null;
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 250;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 10000;
                }

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof R4EUIFileContext) {
                        R4EFileVersion version = ((R4EUIFileContext)element).getTargetFileVersion();
                        if (version != null) {
                            cell.setText(UIUtils.getProjectPath(version));
                        } else {
                            version = ((R4EUIFileContext)element).getBaseFileVersion();
                            if (version != null) {
                                cell.setText(UIUtils.getProjectPath(version));
                            } else {
                                cell.setText(ReviewNavigatorTreeViewer.INVALID_PATH);
                            }
                        }
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fPathColumn.getColumn().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ReviewNavigatorTreeViewer.this.fTreeTableComparator.setColumnName("Path");
                    ReviewNavigatorTreeViewer.this.getTree().setSortDirection(ReviewNavigatorTreeViewer.this.fTreeTableComparator.getDirection());
                    ReviewNavigatorTreeViewer.this.getTree().setSortColumn(ReviewNavigatorTreeViewer.this.fPathColumn.getColumn());
                    ReviewNavigatorTreeViewer.this.refresh();
                }
            });
        }
    }

    private void createAssignmentColumn() {
        if (this.fAssignColumn == null) {
            this.fAssignColumn = new TreeViewerColumn((TreeViewer)this, 0);
            this.fAssignColumn.getColumn().setText("Assigned to");
            this.fTreeColumnLayout.setColumnData((Widget)this.fAssignColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, true));
            this.fAssignColumn.getColumn().setMoveable(true);
            this.fAssignColumn.getColumn().setResizable(true);
            this.fAssignColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof R4EUIReviewItem) {
                        return UIUtils.formatAssignedParticipants((EList<String>)((R4EUIReviewItem)element).getItem().getAssignedTo());
                    }
                    if (element instanceof R4EUIFileContext) {
                        return UIUtils.formatAssignedParticipants((EList<String>)((R4EUIFileContext)element).getFileContext().getAssignedTo());
                    }
                    return null;
                }

                public String getToolTipText(Object element) {
                    return null;
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 250;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 0;
                }

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof R4EUIReviewItem) {
                        cell.setText(UIUtils.formatAssignedParticipants((EList<String>)((R4EUIReviewItem)element).getItem().getAssignedTo()));
                    } else if (element instanceof R4EUIFileContext) {
                        cell.setText(UIUtils.formatAssignedParticipants((EList<String>)((R4EUIFileContext)element).getFileContext().getAssignedTo()));
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fAssignColumn.getColumn().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ReviewNavigatorTreeViewer.this.fTreeTableComparator.setColumnName("Assigned to");
                    ReviewNavigatorTreeViewer.this.getTree().setSortDirection(ReviewNavigatorTreeViewer.this.fTreeTableComparator.getDirection());
                    ReviewNavigatorTreeViewer.this.getTree().setSortColumn(ReviewNavigatorTreeViewer.this.fAssignColumn.getColumn());
                    ReviewNavigatorTreeViewer.this.refresh();
                }
            });
        }
    }

    private void createNumChangesColumn() {
        if (this.fNumChangesColumn == null) {
            this.fNumChangesColumn = new TreeViewerColumn((TreeViewer)this, 0);
            this.fNumChangesColumn.getColumn().setText("Changes");
            this.fTreeColumnLayout.setColumnData((Widget)this.fNumChangesColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, true));
            this.fNumChangesColumn.getColumn().setMoveable(true);
            this.fNumChangesColumn.getColumn().setResizable(true);
            this.fNumChangesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof R4EUIReviewItem) {
                        return UIUtils.formatNumChanges(((R4EUIReviewItem)element).getNumChanges(), ((R4EUIReviewItem)element).getNumReviewedChanges());
                    }
                    if (element instanceof R4EUIFileContext) {
                        return UIUtils.formatNumChanges(((R4EUIFileContext)element).getNumChanges(), ((R4EUIFileContext)element).getNumReviewedChanges());
                    }
                    return null;
                }

                public String getToolTipText(Object element) {
                    if (element instanceof R4EUIReviewItem) {
                        return ReviewNavigatorTreeViewer.NUM_CHANGES_ITEM_COLUMN_TOOLTIP;
                    }
                    return ReviewNavigatorTreeViewer.NUM_CHANGES_FILE_COLUMN_TOOLTIP;
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 250;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 10000;
                }

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof R4EUIReviewItem) {
                        cell.setText(UIUtils.formatNumChanges(((R4EUIReviewItem)element).getNumChanges(), ((R4EUIReviewItem)element).getNumReviewedChanges()));
                    } else if (element instanceof R4EUIFileContext) {
                        cell.setText(UIUtils.formatNumChanges(((R4EUIFileContext)element).getNumChanges(), ((R4EUIFileContext)element).getNumReviewedChanges()));
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fNumChangesColumn.getColumn().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ReviewNavigatorTreeViewer.this.fTreeTableComparator.setColumnName("Changes");
                    ReviewNavigatorTreeViewer.this.getTree().setSortDirection(ReviewNavigatorTreeViewer.this.fTreeTableComparator.getDirection());
                    ReviewNavigatorTreeViewer.this.getTree().setSortColumn(ReviewNavigatorTreeViewer.this.fNumChangesColumn.getColumn());
                    ReviewNavigatorTreeViewer.this.refresh();
                }
            });
        }
    }

    private void createNumAnomaliesColumn() {
        if (this.fNumAnomaliesColumn == null) {
            this.fNumAnomaliesColumn = new TreeViewerColumn((TreeViewer)this, 0);
            this.fNumAnomaliesColumn.getColumn().setText("Anomalies");
            this.fNumAnomaliesColumn.getColumn().setMoveable(true);
            this.fNumAnomaliesColumn.getColumn().setResizable(true);
            this.fTreeColumnLayout.setColumnData((Widget)this.fNumAnomaliesColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, true));
            this.fNumAnomaliesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof R4EUIReviewItem) {
                        return Integer.toString(((R4EUIReviewItem)element).getNumAnomalies());
                    }
                    if (element instanceof R4EUIFileContext) {
                        return Integer.toString(((R4EUIFileContext)element).getNumAnomalies());
                    }
                    return null;
                }

                public String getToolTipText(Object element) {
                    return ReviewNavigatorTreeViewer.NUM_ANOMALIES_COLUMN_TOOLTIP;
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 250;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 10000;
                }

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof R4EUIReviewItem) {
                        cell.setText(Integer.toString(((R4EUIReviewItem)element).getNumAnomalies()));
                    } else if (element instanceof R4EUIFileContext) {
                        cell.setText(Integer.toString(((R4EUIFileContext)element).getNumAnomalies()));
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fNumAnomaliesColumn.getColumn().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ReviewNavigatorTreeViewer.this.fTreeTableComparator.setColumnName("Anomalies");
                    ReviewNavigatorTreeViewer.this.getTree().setSortDirection(ReviewNavigatorTreeViewer.this.fTreeTableComparator.getDirection());
                    ReviewNavigatorTreeViewer.this.getTree().setSortColumn(ReviewNavigatorTreeViewer.this.fNumAnomaliesColumn.getColumn());
                    ReviewNavigatorTreeViewer.this.refresh();
                }
            });
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.setSelectionToWidget(selection, reveal);
        ISelection sel = this.getSelection();
        if (((ITreeSelection)sel).size() == 0 && selection != null) {
            sel = selection;
        }
        this.updateSelection(sel);
        this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, sel));
    }
}

