/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.handlers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.reqcycle.emf.handlers.EMFReachableObject;
import org.polarsys.reqcycle.emf.utils.EMFProxyResolver;
import org.polarsys.reqcycle.emf.utils.EMFUtils;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EMFURIHandler
implements IReachableHandler,
IObjectHandler {
    public boolean handlesReachable(Reachable t) {
        URI uri = EMFUtils.getEMFURI(t);
        return this.handlesURI(uri);
    }

    public boolean handlesURI(URI uri) {
        return EMFUtils.isEMF(uri);
    }

    public ReachableObject getFromReachable(Reachable t) {
        ReachableObject emfReachableObject = this.doGetReachableObject(t);
        ZigguratInject.inject((Object[])new Object[]{emfReachableObject});
        return emfReachableObject;
    }

    protected ReachableObject doGetReachableObject(Reachable t) {
        return new EMFReachableObject(t);
    }

    public boolean handlesObject(Object t) {
        return this.handles(t);
    }

    public boolean handles(Object t) {
        Resource r;
        if (t instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)t;
            Object o = adaptable.getAdapter(Resource.class);
            if (o != null) {
                t = o;
            } else {
                o = adaptable.getAdapter(EObject.class);
                if (o != null) {
                    t = o;
                }
            }
        }
        if (t instanceof EObject && (r = ((EObject)t).eResource()) != null) {
            t = r;
        }
        if (t instanceof Resource) {
            return this.handlesURI(((Resource)t).getURI());
        }
        if (t instanceof IResource) {
            return this.handlesURI(URI.createPlatformResourceURI((String)((IResource)t).getFullPath().toString(), (boolean)true));
        }
        return false;
    }

    public ReachableObject getFromObject(Object o) {
        ReachableObject result = null;
        if (o instanceof IResource) {
            IResource res = (IResource)o;
            result = this.doGetReachableObject(EMFUtils.getReachable(URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true)));
        } else if (o instanceof EObject) {
            result = this.doGetReachableObject(EMFUtils.getReachable((EObject)o));
        } else if (o instanceof Resource) {
            result = this.doGetReachableObject(EMFUtils.getReachable(((Resource)o).getURI()));
        } else if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            result = this.doGetReachableObject(EMFUtils.getReachable((EObject)adaptable.getAdapter(EObject.class)));
        }
        if (result != null) {
            ZigguratInject.inject((Object[])new Object[]{result});
        }
        return result;
    }

    public ProxyResolver getProxyResolver() {
        return new EMFProxyResolver();
    }
}

