/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SpinnerTab
extends ExampleTab {
    private Spinner spinner;
    private Spinner modifySpinner;
    private int minimum = 0;
    private int maximum = 100;
    private int digits = 0;
    private int increment = 1;
    private int pageIncrement = 10;
    private int selection = 0;

    public SpinnerTab(CTabFolder topFolder) {
        super(topFolder, "Spinner");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("READ_ONLY", 8);
        this.createStyleButton("WRAP", 64);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createRangeControls(parent);
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.createCursorCombo();
    }

    protected void createExampleControls(Composite parent) {
        GridLayout gridLayout = new GridLayout(2, false);
        parent.setLayout((Layout)gridLayout);
        Label label = new Label(parent, 0);
        label.setText("Simple Spinner");
        this.spinner = new Spinner(parent, this.getStyle());
        label = new Label(parent, 0);
        label.setText("Spinner with ModifyListener");
        this.modifySpinner = new Spinner(parent, this.getStyle());
        label = new Label(parent, 0);
        label.setText("Current value");
        final Label lblSpinnerValue = new Label(parent, 0);
        lblSpinnerValue.setLayoutData((Object)new GridData(4, 4, true, false));
        lblSpinnerValue.setText(String.valueOf(this.modifySpinner.getSelection()));
        this.modifySpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = String.valueOf(SpinnerTab.this.modifySpinner.getSelection());
                lblSpinnerValue.setText(value);
            }
        });
        this.updateSpinners();
        this.registerControl((Control)this.spinner);
        this.registerControl((Control)this.modifySpinner);
    }

    private void createRangeControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        final Text txtMin = this.createLabeledText((Composite)group, "Minimum", String.valueOf(this.minimum));
        final Text txtMax = this.createLabeledText((Composite)group, "Maximum", String.valueOf(this.maximum));
        final Spinner spnDigits = this.createLabeledSpinner((Composite)group, "Digits", this.digits);
        final Text txtInc = this.createLabeledText((Composite)group, "Increment", String.valueOf(this.increment));
        final Text txtPageInc = this.createLabeledText((Composite)group, "PageIncrement", String.valueOf(this.pageIncrement));
        final Text txtSelection = this.createLabeledText((Composite)group, "Selection", String.valueOf(this.selection));
        Button btnApply = new Button((Composite)group, 8);
        btnApply.setText("Apply");
        GridData btnApplyData = new GridData(128);
        btnApplyData.horizontalSpan = 2;
        btnApply.setLayoutData((Object)btnApplyData);
        btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpinnerTab.this.minimum = SpinnerTab.this.parseInt(txtMin, SpinnerTab.this.spinner.getMinimum());
                SpinnerTab.this.maximum = SpinnerTab.this.parseInt(txtMax, SpinnerTab.this.spinner.getMaximum());
                SpinnerTab.this.digits = spnDigits.getSelection();
                SpinnerTab.this.increment = SpinnerTab.this.parseInt(txtInc, SpinnerTab.this.spinner.getIncrement());
                SpinnerTab.this.pageIncrement = SpinnerTab.this.parseInt(txtPageInc, SpinnerTab.this.spinner.getPageIncrement());
                SpinnerTab.this.selection = SpinnerTab.this.parseInt(txtSelection, SpinnerTab.this.spinner.getSelection());
                SpinnerTab.this.updateSpinners();
            }
        });
    }

    private Text createLabeledText(Composite parent, String text, String value) {
        Label label = new Label(parent, 0);
        label.setText(text);
        Text result = new Text(parent, 2048);
        result.setText(value);
        result.setLayoutData((Object)new GridData(768));
        return result;
    }

    private Spinner createLabeledSpinner(Composite parent, String text, int value) {
        Label label = new Label(parent, 0);
        label.setText(text);
        Spinner result = new Spinner(parent, 2048);
        result.setSelection(value);
        result.setLayoutData((Object)new GridData(768));
        return result;
    }

    private void updateSpinners() {
        this.spinner.setValues(this.selection, this.minimum, this.maximum, this.digits, this.increment, this.pageIncrement);
        this.modifySpinner.setValues(this.selection, this.minimum, this.maximum, this.digits, this.increment, this.pageIncrement);
    }

    private int parseInt(Text text, int oldValue) {
        int result;
        try {
            result = Integer.parseInt(text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            text.setText(String.valueOf(oldValue));
            result = oldValue;
        }
        return result;
    }
}

