/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String JS_PROP_HEIGHT = "height";
    private static final String JS_PROP_WIDTH = "width";
    private static final String PARAM_X = "bounds.x";
    private static final String PARAM_Y = "bounds.y";
    private static final String PARAM_WIDTH = "bounds.width";
    private static final String PARAM_HEIGHT = "bounds.height";
    private static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
    private static final String PROP_BACKGROUND_GRADIENT_PERCENTS = "backgroundGradientPercents";
    private static final String PROP_BACKGROUND_GRADIENT_VERTICAL = "backgroundGradientVertical";
    private static final String PROP_ROUNDED_BORDER_WIDTH = "roundedBorderWidth";
    private static final String PROP_ROUNDED_BORDER_COLOR = "roundedBorderColor";
    private static final String PROP_ROUNDED_BORDER_RADIUS = "roundedBorderRadius";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_VARIANT = "variant";
    private static final String PROP_HELP_LISTENER = "helpListener";
    private static final String JS_PROP_SPACE = "space";
    private static final String JS_PROP_CONTEXT_MENU = "contextMenu";
    private static final String JS_FUNC_SET_TOOL_TIP = "setToolTip";
    private static final String JS_FUNC_SET_ROUNDED_BORDER = "setRoundedBorder";
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final JSListenerInfo HELP_LISTENER_INFO = new JSListenerInfo("keydown", "org.eclipse.swt.EventUtil.helpRequested", JSListenerType.ACTION);
    private static final Rectangle DEF_ROUNDED_BORDER_RADIUS = new Rectangle(0, 0, 0, 0);
    private static final Map parsedFonts = new HashMap();
    static /* synthetic */ Class class$0;

    private WidgetLCAUtil() {
    }

    public static void preserveBounds(Widget widget, Rectangle bounds) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve("bounds", (Object)bounds);
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_TOOL_TIP_TEXT, (Object)text);
    }

    public static void preserveFont(Widget widget, Font font) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_FONT, (Object)font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_FOREGROUND, (Object)foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_BACKGROUND, (Object)background);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_BACKGROUND, (Object)background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, (Object)transparency);
    }

    public static void preserveBackgroundGradient(Widget widget) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = widget.getAdapter((Class)clazz)) != null) {
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter((Widget)widget);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_COLORS, (Object)bgGradientColors);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_PERCENTS, (Object)bgGradientPercents);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_VERTICAL, (Object)new Boolean(bgGradientVertical));
        }
    }

    public static void preserveRoundedBorder(Widget widget) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = widget.getAdapter((Class)clazz)) != null) {
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            int width = gfxAdapter.getRoundedBorderWidth();
            Color color = gfxAdapter.getRoundedBorderColor();
            Rectangle radius = gfxAdapter.getRoundedBorderRadius();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter((Widget)widget);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_WIDTH, (Object)new Integer(width));
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_COLOR, (Object)color);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_RADIUS, (Object)radius);
        }
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_ENABLED, (Object)enabled);
    }

    public static void preserveCustomVariant(Widget widget) {
        String variant = WidgetUtil.getVariant((Widget)widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_VARIANT, (Object)variant);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        Object oldValue = adapter.getPreserved(property);
        return !WidgetLCAUtil.equals(oldValue, newValue);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue, Object defaultValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        boolean result = adapter.isInitialized() ? WidgetLCAUtil.hasChanged(widget, property, newValue) : !WidgetLCAUtil.equals(newValue, defaultValue);
        return result;
    }

    public static String readPropertyValue(Widget widget, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(WidgetUtil.getId((Widget)widget));
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter(eventName);
        return WidgetUtil.getId((Widget)widget).equals(widgetId);
    }

    public static Rectangle readBounds(Widget widget, Rectangle defValue) {
        return WidgetLCAUtil.readBounds(WidgetUtil.getId((Widget)widget), defValue);
    }

    public static Rectangle readBounds(String widgetId, Rectangle defValue) {
        int x = WidgetLCAUtil.readBoundsX(widgetId, defValue.x);
        int y = WidgetLCAUtil.readBoundsY(widgetId, defValue.y);
        int width = WidgetLCAUtil.readBoundsWidth(widgetId, defValue.width);
        int height = WidgetLCAUtil.readBoundsHeight(widgetId, defValue.height);
        return new Rectangle(x, y, width, height);
    }

    public static void writeBounds(Widget widget, Control parent, Rectangle bounds) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        Rectangle oldBounds = (Rectangle)adapter.getPreserved("bounds");
        Rectangle newBounds = bounds;
        if (!adapter.isInitialized() || !newBounds.equals((Object)oldBounds)) {
            if (parent != null) {
                AbstractWidgetLCA parentLCA = WidgetUtil.getLCA((Widget)parent);
                newBounds = parentLCA.adjustCoordinates(widget, newBounds);
            }
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (parent instanceof ScrolledComposite) {
                writer.set(JS_PROP_WIDTH, newBounds.width);
                writer.set(JS_PROP_HEIGHT, newBounds.height);
            } else {
                Object[] args = new Integer[]{new Integer(newBounds.x), new Integer(newBounds.width), new Integer(newBounds.y), new Integer(newBounds.height)};
                writer.set(JS_PROP_SPACE, args);
            }
        }
    }

    public static void writeMenu(Widget widget, Menu menu) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, "menu", menu, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.set(JS_PROP_CONTEXT_MENU, menu);
            if (menu == null) {
                writer.removeListener("contextmenu", "org.eclipse.rwt.widgets.Menu.contextMenuHandler");
            } else {
                writer.addListener("contextmenu", "org.eclipse.rwt.widgets.Menu.contextMenuHandler");
            }
        }
    }

    public static void writeToolTip(Widget widget, String toolTip) throws IOException {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP_TEXT, text, "")) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            Object[] args = new Object[]{widget, text};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_TOOL_TIP, args);
        }
    }

    public static void writeImage(Widget widget, Image image) throws IOException {
        WidgetLCAUtil.writeImage(widget, "image", "icon", image);
    }

    public static void writeImage(Widget widget, String javaProperty, String jsProperty, Image image) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, javaProperty, image, null)) {
            WidgetLCAUtil.writeImage(widget, jsProperty, image);
        }
    }

    public static void writeImage(Widget widget, String jsProperty, Image image) throws IOException {
        String path = image == null ? null : ImageFactory.getImagePath((Image)image);
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.set(jsProperty, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parseFontName(String name) {
        Map map = parsedFonts;
        synchronized (map) {
            String[] result = (String[])parsedFonts.get(name);
            if (result == null) {
                result = name.split(",");
                int i = 0;
                while (i < result.length) {
                    result[i] = result[i].trim();
                    Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
                    result[i] = matcher.replaceAll("");
                    ++i;
                }
                parsedFonts.put(name, result);
            }
            return result;
        }
    }

    public static void writeFont(Widget widget, Font font) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (font != null) {
                FontData fontData = FontUtil.getData((Font)font);
                String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
                Object[] args = new Object[]{widget, names, new Integer(fontData.getHeight()), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
                writer.call(JSWriter.WIDGET_MANAGER_REF, "setFont", args);
            } else {
                writer.reset(PROP_FONT);
            }
        }
    }

    public static void writeForeground(Widget widget, Color newColor) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (newColor != null) {
                writer.set("textColor", newColor);
            } else {
                writer.reset("textColor");
            }
        }
    }

    public static void writeBackground(Widget widget, Color newColor) throws IOException {
        WidgetLCAUtil.writeBackground(widget, newColor, false);
    }

    public static void writeBackground(Widget widget, Color background, boolean transparency) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        boolean changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        if (!changed && !transparency) {
            changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        }
        if (changed) {
            if (transparency) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", (Object)null);
            } else if (background != null) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", background);
            } else {
                writer.reset("backgroundGradient");
                writer.reset("backgroundColor");
            }
        }
    }

    public static void writeBackgroundGradient(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = widget.getAdapter((Class)clazz);
            IWidgetGraphicsAdapter graphicsAdapter = (IWidgetGraphicsAdapter)adapter;
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
            JSWriter writer = JSWriter.getWriterFor(widget);
            Integer[] percents = null;
            if (bgGradientPercents != null) {
                percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
            }
            Object[] args = new Object[]{widget, bgGradientColors, percents, new Boolean(bgGradientVertical)};
            writer.call(JSWriter.WIDGET_MANAGER_REF, "setBackgroundGradient", args);
        }
    }

    private static boolean hasBackgroundGradientChanged(Widget widget) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = widget.getAdapter((Class)clazz);
        IWidgetGraphicsAdapter graphicsAdapter = (IWidgetGraphicsAdapter)adapter;
        Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
        boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
        return WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_VERTICAL, new Boolean(bgGradientVertical), Boolean.FALSE);
    }

    public static void writeRoundedBorder(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = widget.getAdapter((Class)clazz);
            IWidgetGraphicsAdapter graphicAdapter = (IWidgetGraphicsAdapter)adapter;
            int width = graphicAdapter.getRoundedBorderWidth();
            Rectangle radius = graphicAdapter.getRoundedBorderRadius();
            Color color = graphicAdapter.getRoundedBorderColor();
            Object[] args = new Object[]{widget, new Integer(width), color, new Integer(radius.x), new Integer(radius.y), new Integer(radius.width), new Integer(radius.height)};
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_ROUNDED_BORDER, args);
        }
    }

    private static boolean hasRoundedBorderChanged(Widget widget) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = widget.getAdapter((Class)clazz);
        IWidgetGraphicsAdapter graphicsAdapter = (IWidgetGraphicsAdapter)adapter;
        int width = graphicsAdapter.getRoundedBorderWidth();
        Color color = graphicsAdapter.getRoundedBorderColor();
        Rectangle radius = graphicsAdapter.getRoundedBorderRadius();
        return WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_WIDTH, new Integer(width), new Integer(0)) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_COLOR, color, null) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_RADIUS, radius, DEF_ROUNDED_BORDER_RADIUS);
    }

    public static void writeEnabled(Widget widget, boolean enabled) throws IOException {
        Boolean newValue = enabled;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Boolean defValue = Boolean.TRUE;
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, defValue);
    }

    public static String replaceNewLines(String input, String replacement) {
        return EncodingUtil.replaceNewLines((String)input, (String)replacement);
    }

    public static void writeCustomVariant(Widget widget) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        String oldValue = (String)adapter.getPreserved(PROP_VARIANT);
        String newValue = WidgetUtil.getVariant((Widget)widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{"variant_" + oldValue};
            if (oldValue != null) {
                writer.call("removeState", args);
            }
            if (newValue != null) {
                args = new Object[]{"variant_" + newValue};
                writer.call("addState", args);
            }
        }
    }

    public static void writeStyleFlag(Widget widget, int style, String styleName) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        if ((widget.getStyle() & style) != 0) {
            writer.call("addState", new Object[]{"rwt_" + styleName});
        }
    }

    public static void preserveHelpListener(Widget widget) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_HELP_LISTENER, (Object)HelpEvent.hasListener((Adaptable)widget));
    }

    public static void writeHelpListener(Widget widget) throws IOException {
        boolean hasListener = HelpEvent.hasListener((Adaptable)widget);
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.updateListener(HELP_LISTENER_INFO, PROP_HELP_LISTENER, hasListener);
    }

    public static void processHelp(Widget widget) {
        if (WidgetLCAUtil.wasEventSent(widget, "org.eclipse.swt.events.help")) {
            HelpEvent event = new HelpEvent(widget);
            event.processEvent();
        }
    }

    private static String readPropertyValue(String widgetId, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(widgetId);
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    private static int readBoundsY(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_Y);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsX(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_X);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsWidth(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_WIDTH);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsHeight(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_HEIGHT);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsValue(String value, int current) {
        int result = value != null && !"null".equals(value) ? NumberFormatUtil.parseInt((String)value) : current;
        return result;
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }

    public static String escapeText(String text, boolean mnemonics) {
        boolean insertAmp = false;
        StringBuffer buffer = new StringBuffer();
        int textLength = text.length();
        int i = 0;
        while (i < textLength) {
            char ch = text.charAt(i);
            if (ch == '&') {
                if (!mnemonics || insertAmp) {
                    insertAmp = false;
                    buffer.append("&amp;");
                } else if (i + 1 < textLength && text.charAt(i + 1) == '&') {
                    insertAmp = true;
                }
            } else if (ch == '<') {
                buffer.append("&lt;");
            } else if (ch == '>') {
                buffer.append("&gt;");
            } else if (ch == '\"') {
                buffer.append("&quot;");
            } else if (EncodingUtil.isNonDisplayableChar((char)ch)) {
                buffer.append("&#");
                buffer.append((int)ch);
                buffer.append(";");
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return EncodingUtil.truncateAtZero((String)buffer.toString());
    }

    public static void resetBounds() throws IOException {
    }

    public static void resetMenu() throws IOException {
    }

    public static void resetToolTip() throws IOException {
    }

    public static void resetFont() throws IOException {
    }

    public static void resetForeground() throws IOException {
    }

    public static void resetBackground() throws IOException {
    }

    public static void resetEnabled() throws IOException {
    }
}

