/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class BrowserLCA
extends AbstractWidgetLCA {
    static final String BLANK_HTML = "<html><script></script></html>";
    private static final String QX_TYPE = "org.eclipse.swt.browser.Browser";
    private static final String QX_FIELD_SOURCE = "source";
    public static final String EVENT_PROGRESS_COMPLETED = "org.eclipse.swt.events.progressCompleted";
    private static final String PARAM_EXECUTE_RESULT = "executeResult";
    private static final String PARAM_EVALUATE_RESULT = "evaluateResult";
    static final String PARAM_EXECUTE_FUNCTION = "executeFunction";
    static final String PARAM_EXECUTE_ARGUMENTS = "executeArguments";
    static final String PARAM_PROGRESS_LISTENERS = "progressListeners";
    static final String EXECUTED_FUNCTION_NAME;
    static final String EXECUTED_FUNCTION_RESULT;
    static final String EXECUTED_FUNCTION_ERROR;
    private static final String FUNCTIONS_TO_CREATE;
    private static final String FUNCTIONS_TO_DESTROY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_NAME = String.valueOf(clazz.getName()) + "#executedFunctionName.";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_RESULT = String.valueOf(clazz2.getName()) + "#executedFunctionResult.";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_ERROR = String.valueOf(clazz3.getName()) + "#executedFunctionError.";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_CREATE = String.valueOf(clazz4.getName()) + "#functionsToCreate.";
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_DESTROY = String.valueOf(clazz5.getName()) + "#functionsToDestroy.";
    }

    public void preserveValues(Widget widget) {
        Browser browser = (Browser)widget;
        ControlLCAUtil.preserveValues((Control)browser);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)browser);
        boolean hasListeners = ProgressEvent.hasListener((Adaptable)browser);
        adapter.preserve(PARAM_PROGRESS_LISTENERS, (Object)hasListeners);
        WidgetLCAUtil.preserveCustomVariant((Widget)browser);
    }

    public void readData(Widget widget) {
        Browser browser = (Browser)widget;
        this.readExecuteResult(browser);
        this.executeFunction(browser);
        this.fireProgressEvent(browser);
    }

    public void renderChanges(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        ControlLCAUtil.writeChanges((Control)browser);
        BrowserLCA.destroyBrowserFunctions(browser);
        BrowserLCA.writeUrl(browser);
        BrowserLCA.createBrowserFunctions(browser);
        BrowserLCA.writeExecute(browser);
        BrowserLCA.writeFunctionResult(browser);
        this.writeListener(browser);
        WidgetLCAUtil.writeCustomVariant((Widget)browser);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void fireProgressEvent(Browser browser) {
        String fireProgressEvent = WidgetLCAUtil.readPropertyValue((Widget)browser, EVENT_PROGRESS_COMPLETED);
        if (fireProgressEvent != null) {
            ProgressEvent changedEvent = new ProgressEvent((Widget)browser, 1);
            changedEvent.processEvent();
            ProgressEvent completedEvent = new ProgressEvent((Widget)browser, 2);
            completedEvent.processEvent();
        }
    }

    public void readExecuteResult(Browser browser) {
        String executeValue = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_RESULT);
        if (executeValue != null) {
            Object[] parsedValues;
            String evalValue = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EVALUATE_RESULT);
            boolean executeResult = Boolean.valueOf(executeValue);
            Object evalResult = null;
            if (evalValue != null && (parsedValues = BrowserLCA.parseArguments(evalValue)).length == 1) {
                evalResult = parsedValues[0];
            }
            BrowserLCA.getAdapter(browser).setExecuteResult(executeResult, evalResult);
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)browser);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)browser);
    }

    private static void writeUrl(Browser browser) throws IOException {
        if (BrowserLCA.hasUrlChanged(browser)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.set(QX_FIELD_SOURCE, BrowserLCA.getUrl(browser));
            writer.call("syncSource", null);
        }
    }

    static boolean hasUrlChanged(Browser browser) {
        boolean initialized = WidgetUtil.getAdapter((Widget)browser).isInitialized();
        return BrowserLCA.getAdapter(browser).getAndResetUrlChanged() || !initialized;
    }

    static String getUrl(Browser browser) throws IOException {
        String text = BrowserLCA.getText(browser);
        String url = browser.getUrl();
        String result = !"".equals(text.trim()) ? BrowserLCA.registerHtml(text) : (!"".equals(url.trim()) ? url : BrowserLCA.registerHtml(BLANK_HTML));
        return result;
    }

    private static void writeExecute(final Browser browser) {
        IBrowserAdapter adapter = BrowserLCA.getAdapter(browser);
        final String executeScript = adapter.getExecuteScript();
        boolean executePending = adapter.getExecutePending();
        if (executeScript != null && !executePending) {
            RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(new PhaseListener(){
                private static final long serialVersionUID = 1L;

                public void beforePhase(PhaseEvent event) {
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void afterPhase(PhaseEvent event) {
                    if (browser.getDisplay() != LifeCycleUtil.getSessionDisplay()) return;
                    try {
                        try {
                            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
                            writer.call("execute", new Object[]{executeScript});
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener((PhaseListener)this);
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener((PhaseListener)this);
                }

                public PhaseId getPhaseId() {
                    return PhaseId.RENDER;
                }
            });
            adapter.setExecutePending(true);
        }
    }

    private static String registerHtml(String html) throws IOException {
        String name = BrowserLCA.createUrlFromHtml(html);
        byte[] bytes = html.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        IResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(name, (InputStream)inputStream);
        return resourceManager.getLocation(name);
    }

    private static String createUrlFromHtml(String html) {
        StringBuffer result = new StringBuffer();
        result.append("org.eclipse.swt.browser/text");
        result.append(String.valueOf(html.hashCode()));
        result.append(".html");
        return result.toString();
    }

    private static String getText(Browser browser) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = browser.getAdapter((Class)clazz);
        IBrowserAdapter browserAdapter = (IBrowserAdapter)adapter;
        return browserAdapter.getText();
    }

    private static IBrowserAdapter getAdapter(Browser browser) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBrowserAdapter)browser.getAdapter((Class)clazz);
    }

    private void writeListener(Browser browser) throws IOException {
        String prop = PARAM_PROGRESS_LISTENERS;
        boolean hasListener = ProgressEvent.hasListener((Adaptable)browser);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)browser, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.set("hasProgressListener", newValue);
        }
    }

    private static void createBrowserFunctions(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String[] functions = (String[])stateInfo.getAttribute(String.valueOf(FUNCTIONS_TO_CREATE) + id);
        if (functions != null) {
            int i = 0;
            while (i < functions.length) {
                JSWriter writer = JSWriter.getWriterFor((Widget)browser);
                writer.call("createFunction", new Object[]{functions[i]});
                ++i;
            }
        }
    }

    private static void destroyBrowserFunctions(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String[] functions = (String[])stateInfo.getAttribute(String.valueOf(FUNCTIONS_TO_DESTROY) + id);
        if (functions != null) {
            int i = 0;
            while (i < functions.length) {
                JSWriter writer = JSWriter.getWriterFor((Widget)browser);
                writer.call("destroyFunction", new Object[]{functions[i]});
                ++i;
            }
        }
    }

    private void executeFunction(final Browser browser) {
        String function = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_FUNCTION);
        String arguments = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_ARGUMENTS);
        if (function != null) {
            IBrowserAdapter adapter = BrowserLCA.getAdapter(browser);
            BrowserFunction[] functions = adapter.getBrowserFunctions();
            boolean found = false;
            int i = 0;
            while (i < functions.length && !found) {
                final BrowserFunction current = functions[i];
                if (current.getName().equals(function)) {
                    final Object[] args = BrowserLCA.parseArguments(arguments);
                    ProcessActionRunner.add((Runnable)new Runnable(){

                        public void run() {
                            try {
                                Object executedFunctionResult = current.function(args);
                                BrowserLCA.setExecutedFunctionResult(browser, executedFunctionResult);
                            }
                            catch (Exception e) {
                                BrowserLCA.setExecutedFunctionError(browser, e.getMessage());
                            }
                            BrowserLCA.setExecutedFunctionName(browser, current.getName());
                        }
                    });
                    found = true;
                }
                ++i;
            }
        }
    }

    private static void writeFunctionResult(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String name = (String)stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id);
        if (name != null) {
            Object result = stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id);
            if (result != null) {
                result = new JSVar(BrowserLCA.toJson(result, true));
            }
            String error = (String)stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id);
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.call("setFunctionResult", new Object[]{name, result, error});
        }
    }

    private static void setExecutedFunctionName(Browser browser, String name) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id, (Object)name);
    }

    private static void setExecutedFunctionResult(Browser browser, Object result) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id, result);
    }

    private static void setExecutedFunctionError(Browser browser, String error) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id, (Object)error);
    }

    static Object[] parseArguments(String arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (arguments.startsWith("[") && arguments.endsWith("]")) {
            String arg;
            String args = arguments.substring(1, arguments.length() - 1);
            int openQuotes = 0;
            int openBrackets = 0;
            StringBuffer argBuff = new StringBuffer();
            int prevChar = 32;
            int i = 0;
            while (i < args.length()) {
                char ch = args.charAt(i);
                if (ch == ',' && openQuotes == 0 && openBrackets == 0) {
                    arg = argBuff.toString();
                    if (arg.startsWith("[")) {
                        result.add(BrowserLCA.parseArguments(arg));
                    } else {
                        arg = arg.replaceAll("\\\\\"", "\"");
                        result.add(BrowserLCA.withType(arg));
                    }
                    argBuff.setLength(0);
                } else {
                    if (ch == '\"' && prevChar != 92) {
                        openQuotes = openQuotes == 0 ? ++openQuotes : --openQuotes;
                    } else if (ch == '[' && openQuotes == 0) {
                        ++openBrackets;
                    } else if (ch == ']' && openQuotes == 0) {
                        --openBrackets;
                    }
                    argBuff.append(ch);
                }
                prevChar = ch;
                ++i;
            }
            arg = argBuff.toString();
            if (arg.startsWith("[")) {
                result.add(BrowserLCA.parseArguments(arg));
            } else if (!arg.equals("")) {
                arg = arg.replaceAll("\\\\\"", "\"");
                result.add(BrowserLCA.withType(arg));
            }
        }
        return result.toArray();
    }

    static Object withType(String argument) {
        Object result;
        if (argument.equals("null") || argument.equals("undefined")) {
            result = null;
        } else if (argument.equals("true") || argument.equals("false")) {
            result = new Boolean(argument);
        } else if (argument.startsWith("\"")) {
            result = argument.substring(1, argument.length() - 1);
        } else {
            try {
                result = Double.valueOf(argument);
            }
            catch (NumberFormatException numberFormatException) {
                result = argument;
            }
        }
        return result;
    }

    static String toJson(Object object, boolean deleteLastChar) {
        StringBuffer result = new StringBuffer();
        if (object == null) {
            result.append("null");
            result.append(",");
        } else if (object instanceof String) {
            result.append("\"");
            result.append(EncodingUtil.escapeDoubleQuoted((String)((String)object)));
            result.append("\"");
            result.append(",");
        } else if (object instanceof Boolean) {
            result.append(((Boolean)object).toString());
            result.append(",");
        } else if (object instanceof Number) {
            result.append(((Number)object).toString());
            result.append(",");
        } else if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            result.append("[");
            int i = 0;
            while (i < array.length) {
                result.append(BrowserLCA.toJson(array[i], false));
                ++i;
            }
            if (array.length == 0) {
                result.append(",");
            }
            result.insert(result.length() - 1, "]");
        }
        if (deleteLastChar) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

