/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rap.ui.internal.preferences.SessionPreferenceNodeCore;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.SettingStoreException;
import org.eclipse.ui.internal.preferences.Base64;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

final class SessionPreferencesNode
implements IEclipsePreferences {
    private static final String PATH_SEPARATOR = "/";
    private static final String DOUBLE_PATH_SEPARATOR = "//";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final String name;
    private final IEclipsePreferences parent;
    private boolean isRemoved;
    private String absolutePath;
    private final Map children = new HashMap();

    SessionPreferencesNode(IEclipsePreferences parent, String name) {
        ParamCheck.notNull((Object)parent, (String)"parent");
        ParamCheck.notNull((Object)name, (String)"name");
        this.checkName(name);
        this.parent = parent;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        boolean withChildren = visitor.visit((IEclipsePreferences)this);
        if (withChildren) {
            Object[] childrenArray;
            SessionPreferencesNode sessionPreferencesNode = this;
            synchronized (sessionPreferencesNode) {
                childrenArray = this.children.values().toArray();
            }
            int i = 0;
            while (i < childrenArray.length) {
                IEclipsePreferences child = (IEclipsePreferences)childrenArray[i];
                child.accept(visitor);
                ++i;
            }
        }
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (listener != null) {
            this.getNodeCore().addNodeChangeListener(listener);
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.getNodeCore().addPreferenceChangeListener(listener);
    }

    public Preferences node(String path) {
        SessionPreferencesNode result;
        this.checkPath(path);
        this.checkRemoved();
        if ("".equals(path)) {
            result = this;
        } else if (path.startsWith(PATH_SEPARATOR)) {
            result = this.findRoot().node(path.substring(1));
        } else if (path.indexOf(PATH_SEPARATOR) > 0) {
            int index = path.indexOf(PATH_SEPARATOR);
            String nodeName = path.substring(0, index);
            String rest = path.substring(index + 1, path.length());
            result = this.getChild(nodeName, true).node(rest);
        } else {
            result = this.getChild(path, true);
        }
        return result;
    }

    public synchronized void removeNode() throws BackingStoreException {
        this.checkRemoved();
        this.clear();
        Object[] childNodes = this.children.values().toArray();
        int i = 0;
        while (i < childNodes.length) {
            Preferences child = (Preferences)childNodes[i];
            if (child.nodeExists("")) {
                child.removeNode();
            }
            ++i;
        }
        if (this.parent instanceof SessionPreferencesNode) {
            SessionPreferencesNode spnParent = (SessionPreferencesNode)this.parent;
            spnParent.children.remove(this.name);
            spnParent.fireNodeEvent((Preferences)this, false);
            this.getNodeCore().clear();
            this.children.clear();
            this.isRemoved = true;
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (listener != null) {
            this.getNodeCore().removeNodeChangeListener(listener);
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.getNodeCore().removePreferenceChangeListener(listener);
    }

    public String absolutePath() {
        if (this.absolutePath == null) {
            String parentPath;
            this.absolutePath = this.parent == null ? this.name : ((parentPath = this.parent.absolutePath()).endsWith(PATH_SEPARATOR) ? String.valueOf(parentPath) + this.name : String.valueOf(parentPath) + PATH_SEPARATOR + this.name);
        }
        return this.absolutePath;
    }

    public synchronized String[] childrenNames() {
        this.checkRemoved();
        Set names = this.children.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void clear() {
        this.checkRemoved();
        String[] keys = this.internalGetKeys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
    }

    public void flush() {
        this.checkRemoved();
    }

    public String get(String key, String def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String result = this.internalGet(key);
        return result == null ? def : result;
    }

    public boolean getBoolean(String key, boolean def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        return value == null ? def : Boolean.valueOf(value);
    }

    public byte[] getByteArray(String key, byte[] def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        return value == null ? def : Base64.decode(value.getBytes());
    }

    public double getDouble(String key, double def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        double result = def;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public float getFloat(String key, float def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        float result = def;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public int getInt(String key, int def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        int result = def;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public long getLong(String key, long def) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String value = this.internalGet(key);
        long result = def;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public String[] keys() {
        this.checkRemoved();
        return this.internalGetKeys();
    }

    public String name() {
        return this.name;
    }

    public synchronized boolean nodeExists(String path) throws BackingStoreException {
        boolean result;
        if ("".equals(path)) {
            result = !this.isRemoved;
        } else {
            this.checkRemoved();
            this.checkPath(path);
            if (path.startsWith(PATH_SEPARATOR)) {
                result = this.findRoot().nodeExists(path.substring(1));
            } else if (path.indexOf(PATH_SEPARATOR) > 0) {
                int index = path.indexOf(PATH_SEPARATOR);
                String nodeName = path.substring(0, index);
                String rest = path.substring(index + 1, path.length());
                SessionPreferencesNode child = this.getChild(nodeName, false);
                result = child == null ? false : child.nodeExists(rest);
            } else {
                result = this.children.containsKey(path);
            }
        }
        return result;
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    public void put(String key, String newValue) {
        ParamCheck.notNull((Object)key, (String)"key");
        ParamCheck.notNull((Object)newValue, (String)"newValue");
        this.checkRemoved();
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String newValue = value ? TRUE : FALSE;
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putByteArray(String key, byte[] value) {
        ParamCheck.notNull((Object)key, (String)"key");
        ParamCheck.notNull((Object)value, (String)"newValue");
        this.checkRemoved();
        String newValue = new String(Base64.encode(value));
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putDouble(String key, double value) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String newValue = String.valueOf(value);
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putFloat(String key, float value) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String newValue = String.valueOf(value);
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putInt(String key, int value) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String newValue = String.valueOf(value);
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putLong(String key, long value) {
        ParamCheck.notNull((Object)key, (String)"key");
        this.checkRemoved();
        String newValue = String.valueOf(value);
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.getNodeCore().firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void remove(String key) {
        this.checkRemoved();
        String oldValue = this.internalGet(key);
        if (oldValue != null) {
            this.internalPut(key, null);
            this.getNodeCore().firePreferenceEvent(key, oldValue, null);
        }
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        ISettingStore store = RWT.getSettingStore();
        String id = store.getId();
        try {
            store.loadById(id);
        }
        catch (SettingStoreException sse) {
            throw new BackingStoreException("Failed to sync() node", (Throwable)sse);
        }
    }

    public String toString() {
        return String.valueOf(this.absolutePath()) + "@" + this.hashCode();
    }

    private void checkName(String nodeName) {
        if (nodeName.indexOf(PATH_SEPARATOR) != -1) {
            String unboundMsg = "Name ''{0}'' cannot contain or end with ''{1}''";
            String msg = NLS.bind((String)unboundMsg, (Object)nodeName, (Object)PATH_SEPARATOR);
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkPath(String path) {
        if (path.indexOf(DOUBLE_PATH_SEPARATOR) != -1) {
            String unboundMsg = "''{0}'' is not allowed in path ''{1}''";
            String msg = NLS.bind((String)unboundMsg, (Object)DOUBLE_PATH_SEPARATOR, (Object)path);
            throw new IllegalArgumentException(msg);
        }
        if (path.length() > 1 && path.endsWith(PATH_SEPARATOR)) {
            String unboundMsg = "path ''{0}'' cannot end with ''{1}''";
            String msg = NLS.bind((String)unboundMsg, (Object)path, (Object)PATH_SEPARATOR);
            throw new IllegalArgumentException(msg);
        }
    }

    private synchronized void checkRemoved() {
        if (this.isRemoved) {
            String msg = "node ''{0}'' has been removed";
            throw new IllegalStateException(NLS.bind((String)msg, (Object)this.absolutePath()));
        }
    }

    private synchronized SessionPreferencesNode createChild(String childName) {
        SessionPreferencesNode result = new SessionPreferencesNode(this, childName);
        this.children.put(childName, result);
        this.fireNodeEvent((Preferences)result, true);
        return result;
    }

    private synchronized SessionPreferencesNode getChild(String childName, boolean doCreate) {
        SessionPreferencesNode result = (SessionPreferencesNode)this.children.get(childName);
        if (result == null && doCreate) {
            result = this.createChild(childName);
        }
        return result;
    }

    private String[] internalGetKeys() {
        ArrayList<String> result = new ArrayList<String>();
        String prefix = String.valueOf(this.absolutePath()) + PATH_SEPARATOR;
        int prefixLength = prefix.length();
        Enumeration attrNames = RWT.getSettingStore().getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attr = (String)attrNames.nextElement();
            if (!attr.startsWith(prefix)) continue;
            String key = attr.substring(prefixLength);
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    private Preferences findRoot() {
        SessionPreferencesNode result = this;
        while (result.parent() != null) {
            result = result.parent();
        }
        return result;
    }

    private String internalGet(String key) {
        ISettingStore store = RWT.getSettingStore();
        String uniqueKey = String.valueOf(this.absolutePath()) + PATH_SEPARATOR + key;
        return store.getAttribute(uniqueKey);
    }

    private synchronized String internalPut(String key, String value) {
        String uniqueKey = String.valueOf(this.absolutePath()) + PATH_SEPARATOR + key;
        return this.getNodeCore().put(uniqueKey, value);
    }

    private void fireNodeEvent(Preferences child, boolean wasAdded) {
        this.getNodeCore().fireNodeEvent(child, wasAdded, this);
    }

    private SessionPreferenceNodeCore getNodeCore() {
        SessionPreferenceNodeCore result;
        String key = this.absolutePath();
        Object object = RWT.getSessionStore().getAttribute(key);
        if (object instanceof SessionPreferenceNodeCore) {
            result = (SessionPreferenceNodeCore)object;
        } else {
            result = new SessionPreferenceNodeCore(this);
            RWT.getSessionStore().setAttribute(key, (Object)result);
        }
        return result;
    }
}

