/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.resources.IResourceManager;

public class TestResourceManager
implements IResourceManager {
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private final Set<String> registeredResources = new HashSet<String>();

    public String getCharset(String name) {
        return null;
    }

    public ClassLoader getContextLoader() {
        return this.loader;
    }

    public String getLocation(String name) {
        return "rwt-resources/" + name;
    }

    public URL getResource(String name) {
        URL result = null;
        if (this.loader != null) {
            result = this.loader.getResource(name);
        }
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream result = null;
        if (this.loader != null) {
            result = this.loader.getResourceAsStream(name);
        }
        return result;
    }

    public Enumeration getResources(String name) throws IOException {
        Enumeration<URL> result = null;
        if (this.loader != null) {
            result = this.loader.getResources(name);
        }
        return result;
    }

    public boolean isRegistered(String name) {
        return this.registeredResources.contains(name);
    }

    public void register(String name) {
        this.createResourcesDirectory();
        this.registeredResources.add(name);
    }

    public void register(String name, InputStream is) {
        this.createResourcesDirectory();
        this.registeredResources.add(name);
    }

    public void register(String name, String charset) {
        this.createResourcesDirectory();
        this.registeredResources.add(name);
    }

    public void register(String name, String charset, IResourceManager.RegisterOptions options) {
        this.createResourcesDirectory();
        this.registeredResources.add(name);
    }

    public void register(String name, InputStream is, String charset, IResourceManager.RegisterOptions options) {
        this.createResourcesDirectory();
        this.registeredResources.add(name);
    }

    public boolean unregister(String name) {
        return this.registeredResources.remove(name);
    }

    public void setContextLoader(ClassLoader contextLoader) {
        this.loader = contextLoader;
    }

    public InputStream getRegisteredContent(String name) {
        return null;
    }

    private void createResourcesDirectory() {
        File contextDirectory;
        File file;
        if (this.registeredResources.isEmpty() && !(file = new File(contextDirectory = RWTFactory.getConfiguration().getContextDirectory(), "rwt-resources")).exists()) {
            file.mkdirs();
        }
    }
}

