/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.internal.widgets.IAggregateHyperlinkSegmentAdapter;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.SelectionData;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;

public class AggregateHyperlinkSegment
extends ParagraphSegment
implements IHyperlinkSegment,
Adaptable {
    private String href;
    private Vector segments = new Vector();
    private IAggregateHyperlinkSegmentAdapter aggregateHyperlinkSegmentAdapter;

    public Object getAdapter(Class adapter) {
        IAggregateHyperlinkSegmentAdapter result = null;
        if (adapter == IAggregateHyperlinkSegmentAdapter.class) {
            if (this.aggregateHyperlinkSegmentAdapter == null) {
                this.aggregateHyperlinkSegmentAdapter = new IAggregateHyperlinkSegmentAdapter(){

                    @Override
                    public Object[] getHyperlinkSegments() {
                        return AggregateHyperlinkSegment.this.segments.toArray();
                    }
                };
            }
            result = this.aggregateHyperlinkSegmentAdapter;
        }
        return result;
    }

    public void add(TextHyperlinkSegment segment) {
        this.segments.add(segment);
    }

    public void add(ImageHyperlinkSegment segment) {
        this.segments.add(segment);
    }

    @Override
    public boolean advanceLocator(GC gc, int wHint, Locator loc, Hashtable objectTable, boolean computeHeightOnly) {
        boolean newLine = false;
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
            if (segment.advanceLocator(gc, wHint, loc, objectTable, computeHeightOnly)) {
                newLine = true;
            }
            ++i;
        }
        return newLine;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public String getText() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)this.segments.get(i);
            buf.append(segment.getText());
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)this.segments.get(i);
            Rectangle sbounds = segment.getBounds();
            bounds.x = Math.min(bounds.x, sbounds.x);
            bounds.y = Math.min(bounds.y, sbounds.y);
            bounds.width = Math.max(bounds.width, sbounds.width);
            bounds.height = Math.max(bounds.height, sbounds.height);
            ++i;
        }
        return bounds;
    }

    @Override
    public boolean contains(int x, int y) {
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)this.segments.get(i);
            if (segment.contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle rect) {
        int i = 0;
        while (i < this.segments.size()) {
            IHyperlinkSegment segment = (IHyperlinkSegment)this.segments.get(i);
            if (segment.intersects(rect)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void layout(GC gc, int width, Locator locator, Hashtable resourceTable, boolean selected) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
            segment.layout(gc, width, locator, resourceTable, selected);
            ++i;
        }
    }

    @Override
    public void computeSelection(GC gc, Hashtable resourceTable, SelectionData selData) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
            segment.computeSelection(gc, resourceTable, selData);
            ++i;
        }
    }

    @Override
    public void clearCache(String fontId) {
        int i = 0;
        while (i < this.segments.size()) {
            ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
            segment.clearCache(fontId);
            ++i;
        }
    }

    @Override
    public String getTooltipText() {
        if (this.segments.size() > 0) {
            return ((ParagraphSegment)this.segments.get(0)).getTooltipText();
        }
        return super.getTooltipText();
    }

    @Override
    public boolean isFocusSelectable(Hashtable resourceTable) {
        return true;
    }

    @Override
    public boolean setFocus(Hashtable resourceTable, boolean direction) {
        return true;
    }
}

