/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class FocusCellOwnerDrawHighlighter
extends FocusCellHighlighter {
    private final ColumnViewer viewer;

    public FocusCellOwnerDrawHighlighter(ColumnViewer viewer) {
        super(viewer);
        this.viewer = viewer;
        viewer.getControl().setData(Table.ALWAYS_HIDE_SELECTION, (Object)Boolean.TRUE);
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        Color foreground;
        Color background = cell.getControl().isFocusControl() ? this.getSelectedCellBackgroundColor(cell) : this.getSelectedCellBackgroundColorNoFocus(cell);
        Color color = foreground = cell.getControl().isFocusControl() ? this.getSelectedCellForegroundColor(cell) : this.getSelectedCellForegroundColorNoFocus(cell);
        if (foreground != null || background != null || this.onlyTextHighlighting(cell)) {
            if (background == null) {
                background = cell.getItem().getDisplay().getSystemColor(26);
            }
            if (foreground == null) {
                foreground = cell.getItem().getDisplay().getSystemColor(27);
            }
            cell.setBackground(background);
            cell.setForeground(foreground);
        }
    }

    private void removeSelectionInformation(Event event, ViewerCell cell) {
        Color cellBackground = null;
        Color cellForeground = null;
        CellLabelProvider labelProvider = this.viewer.getLabelProvider(cell.getColumnIndex());
        if (labelProvider instanceof ColumnLabelProvider) {
            ColumnLabelProvider columnLabelProvider = (ColumnLabelProvider)labelProvider;
            cellBackground = columnLabelProvider.getBackground(cell.getElement());
            cellForeground = columnLabelProvider.getForeground(cell.getElement());
        }
        cell.setBackground(cellBackground);
        cell.setForeground(cellForeground);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellBackgroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected boolean onlyTextHighlighting(ViewerCell cell) {
        return true;
    }

    @Override
    protected void init() {
        ColumnViewerEditorActivationListener listener = new ColumnViewerEditorActivationListener(){

            @Override
            public void afterEditorActivated(ColumnViewerEditorActivationEvent e) {
            }

            @Override
            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent e) {
                FocusCellOwnerDrawHighlighter.this.focusCellChanged(FocusCellOwnerDrawHighlighter.this.getFocusCell(), null);
            }

            @Override
            public void beforeEditorActivated(ColumnViewerEditorActivationEvent e) {
            }

            @Override
            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent e) {
            }
        };
        ColumnViewerEditor editor = this.viewer.getColumnViewerEditor();
        editor.addEditorActivationListener(listener);
    }

    @Override
    protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
        if (oldCell != null) {
            this.removeSelectionInformation(null, oldCell);
        }
        if (newCell != null) {
            this.markFocusedCell(null, newCell);
        }
    }
}

