/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.HashSet;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.set.ObservableSet;

public class ListToSetAdapter<E>
extends ObservableSet<E> {
    private final IObservableList<E> list;
    private IListChangeListener<E> listener = event -> {
        ListDiffEntry<E>[] differences;
        HashSet added = new HashSet();
        HashSet removed = new HashSet();
        ListDiffEntry<E>[] listDiffEntryArray = differences = event.diff.getDifferences();
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            ListDiffEntry entry = listDiffEntryArray[n2];
            Object element = entry.getElement();
            if (entry.isAddition()) {
                if (this.wrappedSet.add(element) && !removed.remove(element)) {
                    added.add(element);
                }
            } else if (this.wrappedSet.remove(element)) {
                removed.add(element);
                added.remove(element);
            }
            ++n2;
        }
        this.fireSetChange(Diffs.createSetDiff(added, removed));
    };

    public ListToSetAdapter(IObservableList<E> list) {
        super(list.getRealm(), new HashSet(), list.getElementType());
        this.list = list;
        this.wrappedSet.addAll(list);
        this.list.addListChangeListener(this.listener);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.list != null && this.listener != null) {
            this.list.removeListChangeListener(this.listener);
            this.listener = null;
        }
    }
}

