/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import org.eclipse.jdt.internal.junit.runner.FirstRunExecutionListener;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.TestIdMap;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;

public class RerunExecutionListener
extends FirstRunExecutionListener {
    private String fStatus = "OK";

    public RerunExecutionListener(MessageSender sender, TestIdMap ids) {
        super(sender, ids);
    }

    @Override
    public synchronized void notifyTestFailed(TestReferenceFailure failure) {
        this.sendFailure(failure, "%RTRACES", "%RTRACEE");
        String status = failure.getStatus();
        if ("%FAILED ".equals(status)) {
            this.fStatus = "FAILURE";
        } else if ("%ERROR  ".equals(status)) {
            this.fStatus = "ERROR";
        } else {
            throw new IllegalArgumentException(status);
        }
    }

    @Override
    public void notifyTestStarted(ITestIdentifier test) {
    }

    @Override
    public void notifyTestEnded(ITestIdentifier test) {
    }

    public String getStatus() {
        return this.fStatus;
    }
}

