/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.Calendar;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class DateTimeTab
extends ExampleTab {
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    private DateTime dateTime;
    private Group group1;
    private Group group2;
    private Group group3;

    DateTimeTab() {
        super("DateTime");
        this.setDefaultStyle(67616);
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.group1 = new Group(this.styleComp, 4);
        this.group1.setText("Type");
        this.group1.setLayout((Layout)new RowLayout(512));
        this.createStyleButton((Composite)this.group1, "DATE", 32, 16, true);
        this.createStyleButton((Composite)this.group1, "TIME", 128, 16, false);
        this.createStyleButton((Composite)this.group1, "CALENDAR", 1024, 16, false);
        this.group2 = new Group(this.styleComp, 4);
        this.group2.setText("Details");
        this.group2.setLayout((Layout)new RowLayout(512));
        this.createStyleButton((Composite)this.group2, "SHORT", 32768, 16, false);
        this.createStyleButton((Composite)this.group2, "MEDIUM", 65536, 16, true);
        this.createStyleButton((Composite)this.group2, "LONG", 0x10000000, 16, false);
        this.createStyleButton("DROP_DOWN", 4, false);
        this.createStyleButton("BORDER", 2048, true);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFontChooser();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
        this.group3 = new Group(parent, 0);
        this.group3.setText("Min/Max Limit");
        this.group3.setLayout((Layout)new GridLayout(3, false));
        this.createMinMaxLimit((Composite)this.group3);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        int style = this.getStyle() | this.getStyle((Composite)this.group1) | this.getStyle((Composite)this.group2);
        this.dateTime = new DateTime(parent, style);
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu dateTimeMenu = new Menu((Control)this.dateTime);
            MenuItem dateTimeMenuItem = new MenuItem(dateTimeMenu, 8);
            dateTimeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the DateTime";
                    MessageDialog.openInformation((Shell)DateTimeTab.this.dateTime.getShell(), (String)"Information", (String)message);
                }
            });
            dateTimeMenuItem.setText("DateTime context menu item");
            this.dateTime.setMenu(dateTimeMenu);
        }
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.dateTime.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "DateTime WidgetSelected! Selected date: " + DateTimeTab.this.dateTime.getDay() + "/" + (DateTimeTab.this.dateTime.getMonth() + 1) + "/" + DateTimeTab.this.dateTime.getYear() + " " + DateTimeTab.this.dateTime.getHours() + ":" + DateTimeTab.this.dateTime.getMinutes() + ":" + DateTimeTab.this.dateTime.getSeconds();
                    DateTimeTab.this.log(message);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    DateTimeTab.this.log("DateTime WidgetDefaultSelected!");
                }
            });
        }
        this.registerControl((Control)this.dateTime);
    }

    protected Button createStyleButton(Composite parent, String name, int style, int buttonStyle, boolean checked) {
        Button button = new Button(parent, buttonStyle);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DateTimeTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    private void createMinMaxLimit(Composite parent) {
        Label minLabel = new Label(parent, 0);
        minLabel.setText("Minimum");
        final DateTime minDate = new DateTime(parent, 67616);
        final DateTime minTime = new DateTime(parent, 34944);
        Label maxLabel = new Label(parent, 0);
        maxLabel.setText("Maximum");
        final DateTime maxDate = new DateTime(parent, 67616);
        final DateTime maxTime = new DateTime(parent, 34944);
        Button clearButton = new Button((Composite)this.group3, 8);
        clearButton.setText("Clear");
        clearButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DateTimeTab.this.dateTime.setMinimum(null);
                DateTimeTab.this.dateTime.setMaximum(null);
            }
        });
        Button applyButton = new Button((Composite)this.group3, 8);
        applyButton.setText("Apply");
        applyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Calendar limit = Calendar.getInstance();
                limit.set(minDate.getYear(), minDate.getMonth(), minDate.getDay(), minTime.getHours(), minTime.getMinutes(), minTime.getSeconds());
                DateTimeTab.this.dateTime.setMinimum(limit.getTime());
                limit.set(maxDate.getYear(), maxDate.getMonth(), maxDate.getDay(), maxTime.getHours(), maxTime.getMinutes(), maxTime.getSeconds());
                DateTimeTab.this.dateTime.setMaximum(limit.getTime());
            }
        });
    }

    protected int getStyle(Composite comp) {
        Control[] ctrls;
        int result = 0;
        if (this.checkControl((Control)comp) && (ctrls = comp.getChildren()).length != 0) {
            int i = 0;
            while (i < ctrls.length) {
                Object data;
                Button button;
                if (ctrls[i] instanceof Button && (button = (Button)ctrls[i]).getSelection() && (data = button.getData("style")) != null && data instanceof Integer) {
                    int style = (Integer)data;
                    result |= style;
                }
                ++i;
            }
        }
        return result;
    }
}

