/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TclCheckerPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFERENCES_ID = "org.eclipse.dltk.tcl.tclchecker.ui.preferences.TclCheckerPreferences";
    private Text path;
    private Button errorsMode;
    private Button errorsAndUsageWarningsMode;
    private Button allMode;
    private Table problemsTable;

    public TclCheckerPreferences() {
    }

    public TclCheckerPreferences(String title) {
        super(title);
    }

    public TclCheckerPreferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    public static boolean checkTclCheckerPath(boolean askUser) {
        IPreferenceStore store = TclCheckerPlugin.getDefault().getPreferenceStore();
        while (!TclCheckerHelper.canExecuteTclChecker(store)) {
            if (!askUser) {
                return false;
            }
            if (MessageDialog.openQuestion(null, (String)PreferencesMessages.TclChecker_path_configureTitle, (String)PreferencesMessages.TclChecker_path_configureMessage)) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)PREFERENCES_ID, null, null);
                dialog.open();
                continue;
            }
            return false;
        }
        return true;
    }

    protected void setModeSelection(int mode) {
        this.errorsMode.setSelection(mode == 0);
        this.errorsAndUsageWarningsMode.setSelection(mode == 1);
        this.allMode.setSelection(mode == 2);
    }

    protected int getModeSelection() {
        if (this.errorsMode.getSelection()) {
            return 0;
        }
        if (this.errorsAndUsageWarningsMode.getSelection()) {
            return 1;
        }
        if (this.allMode.getSelection()) {
            return 2;
        }
        return -1;
    }

    public void validateTclCheckerPath() {
        String txtPath = this.path.getText().trim();
        if ("".equals(txtPath)) {
            this.setMessage(PreferencesMessages.TclChecker_path_isempty, 2);
            this.setValid(true);
            return;
        }
        IPath path = Path.fromOSString((String)txtPath);
        File file = path.toFile();
        if (!path.isValidPath(path.toOSString())) {
            this.setMessage(PreferencesMessages.TclChecker_path_isinvalid, 3);
            this.setValid(false);
        } else if (!file.isFile()) {
            this.setMessage(PreferencesMessages.TclChecker_path_notexists, 3);
            this.setValid(false);
        } else if (!file.exists()) {
            this.setMessage(PreferencesMessages.TclChecker_path_notexists, 3);
            this.setValid(false);
        } else if (txtPath.indexOf("tclchecker") == -1) {
            this.setMessage(PreferencesMessages.TclChecker_path_notlookslike, 2);
            this.setValid(true);
        } else {
            this.setMessage(null);
            this.setValid(true);
        }
    }

    protected void createModeGroup(Composite parent, Object data) {
        Group radioGroup = new Group(parent, 0);
        radioGroup.setText(PreferencesMessages.TclChecker_mode);
        radioGroup.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        radioGroup.setLayout((Layout)layout);
        this.errorsMode = new Button((Composite)radioGroup, 16);
        this.errorsMode.setText(PreferencesMessages.TclChecker_mode_errors);
        this.errorsAndUsageWarningsMode = new Button((Composite)radioGroup, 16);
        this.errorsAndUsageWarningsMode.setText(PreferencesMessages.TclChecker_mode_errorsAndUsageWarnings);
        this.allMode = new Button((Composite)radioGroup, 16);
        this.allMode.setText(PreferencesMessages.TclChecker_mode_all);
    }

    protected void createPathGroup(final Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_path);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.path = new Text((Composite)group, 2048);
        GridData pathData = new GridData();
        pathData.grabExcessHorizontalSpace = true;
        pathData.horizontalAlignment = 4;
        this.path.setLayoutData((Object)pathData);
        this.path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TclCheckerPreferences.this.validateTclCheckerPath();
            }
        });
        Button browse = new Button((Composite)group, 8);
        browse.setText(PreferencesMessages.TclChecker_browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                String file = dialog.open();
                if (file != null) {
                    TclCheckerPreferences.this.path.setText(file);
                }
            }
        });
    }

    protected void setSelection(boolean value) {
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
    }

    protected void invertSelection() {
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(!items[i].getChecked());
            ++i;
        }
    }

    protected void createSuppressProblemsGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_suppressProblems);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.problemsTable = new Table((Composite)group, 33312);
        this.problemsTable.setBounds(0, 0, 150, 200);
        this.problemsTable.setHeaderVisible(false);
        GridData tableData = new GridData(4, 4, true, true, 0, 0);
        tableData.heightHint = 100;
        this.problemsTable.setLayoutData((Object)tableData);
        TableColumn problemsColumn = new TableColumn(this.problemsTable, 16384);
        problemsColumn.setWidth(200);
        TableColumn typesColumn = new TableColumn(this.problemsTable, 16384);
        typesColumn.setWidth(100);
        List problems = TclCheckerProblemDescription.getProblemIdentifiers();
        Collections.sort(problems);
        Iterator it = problems.iterator();
        while (it.hasNext()) {
            TableItem item = new TableItem(this.problemsTable, 0);
            String problemId = (String)it.next();
            item.setData((Object)problemId);
            String type = TclCheckerProblemDescription.getProblemType(problemId);
            int category = TclCheckerProblemDescription.matchProblemCategory(type);
            String typeString = "";
            if (TclCheckerProblemDescription.isError(category)) {
                typeString = PreferencesMessages.TclChecker_error;
            } else if (TclCheckerProblemDescription.isWarning(category)) {
                typeString = PreferencesMessages.TclChecker_warning;
            }
            item.setText(new String[]{problemId, typeString});
        }
        Composite buttonsComposite = new Composite((Composite)group, 0);
        RowLayout buttonsLayout = new RowLayout();
        buttonsLayout.type = 512;
        buttonsLayout.fill = true;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 128;
        buttonsComposite.setLayoutData((Object)buttonsData);
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(PreferencesMessages.TclChecker_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerPreferences.this.setSelection(true);
            }
        });
        Button clearSelection = new Button(buttonsComposite, 8);
        clearSelection.setText(PreferencesMessages.TclChecker_clearSelection);
        clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerPreferences.this.setSelection(false);
            }
        });
        Button invertSelection = new Button(buttonsComposite, 8);
        invertSelection.setText(PreferencesMessages.TclChecker_invertSelection);
        invertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = TclCheckerPreferences.this.problemsTable.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(!items[i].getChecked());
                    ++i;
                }
            }
        });
    }

    public Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        top.setLayout((Layout)layout);
        this.createPathGroup(top, new GridData(4, 0, true, false));
        this.createModeGroup(top, new GridData(4, 0, true, false));
        this.createSuppressProblemsGroup(top, new GridData(4, 4, true, true));
        this.initializeValues();
        this.validateTclCheckerPath();
        return top;
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TclCheckerPlugin.getDefault().getPreferenceStore();
    }

    public void initializeValues() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.path.setText(store.getString("tclchecker.path"));
        this.setModeSelection(store.getInt("tclchecker.mode"));
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            item.setChecked(store.getBoolean((String)item.getData()));
            ++i;
        }
    }

    protected void performDefaults() {
        this.setModeSelection(2);
        this.setSelection(false);
    }

    public boolean performOk() {
        IPreferenceStore store = this.doGetPreferenceStore();
        store.setValue("tclchecker.path", this.path.getText());
        store.setValue("tclchecker.mode", this.getModeSelection());
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            store.setValue((String)item.getData(), item.getChecked());
            ++i;
        }
        return true;
    }
}

