/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 
 *******************************************************************************/
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;

public class RubyDAssgnExpression extends RubyAssignment {

	// private String name;
	private SimpleReference left;

	/**
	 * @deprecated use RubyDAssgnExpression(int start, int end, String name,
	 *             ASTNode value) only
	 */
	public RubyDAssgnExpression(int start, int end) {
		super(null, null);
		this.setStart(start);
		this.setEnd(end);
	}

	public RubyDAssgnExpression(int start, int end, String name, ASTNode value) {
		super(null, value);
		this.left = new VariableReference(start, start + name.length(), name);
		this.setStart(start);
		this.setEnd(end);
	}

	public String getName() {
		return left.getName();
	}

	public void setName(String name) {
		left.setName(name);
	}

	public int getKind() {
		return 0;
	}

	public ASTNode getLeft() {
		return left;
	}

}
