/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;

public class TestPessimisticProvider
extends RepositoryProvider
implements IFileModificationValidator {
    private static TestPessimisticProvider soleInstance;
    public static final String NATURE_ID = "org.eclipse.dltk.core.tests.model.pessimisticnature";
    public static boolean markWritableOnEdit;
    public static boolean markWritableOnSave;

    public TestPessimisticProvider() {
        soleInstance = this;
    }

    public void configureProject() {
    }

    public String getID() {
        return NATURE_ID;
    }

    public void deconfigure() {
    }

    public IFileModificationValidator getFileModificationValidator() {
        return soleInstance;
    }

    public IStatus validateEdit(final IFile[] files, Object context) {
        if (markWritableOnEdit) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        int i = 0;
                        int length = files.length;
                        while (i < length) {
                            try {
                                TestPessimisticProvider.this.setReadOnly((IResource)files[i], false);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }
                }, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateSave(IFile file) {
        if (markWritableOnSave) {
            try {
                this.setReadOnly((IResource)file, false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public void setReadOnly(IResource resource, boolean readOnly) throws CoreException {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes != null) {
            resourceAttributes.setReadOnly(readOnly);
            resource.setResourceAttributes(resourceAttributes);
        }
    }

    public boolean isReadOnly(IResource resource) throws CoreException {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes != null) {
            return resourceAttributes.isReadOnly();
        }
        return false;
    }
}

