/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclSwitchStatement;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.emf.common.util.EList;

public class TclSwitchCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        TclSwitchStatement switchStatement;
        block13: {
            int patternsStart;
            block14: {
                TclArgument processedArgument;
                Expression at;
                block15: {
                    switchStatement = new TclSwitchStatement(statement.sourceStart(), statement.sourceEnd());
                    this.addToParent(parent, (ASTNode)switchStatement);
                    patternsStart = -1;
                    int i = 1;
                    while (i < statement.getCount()) {
                        Expression at2 = statement.getAt(i);
                        if (at2 instanceof SimpleReference) {
                            String value = ((SimpleReference)at2).getName();
                            if (!("-exact".equals(value) || "-regexp".equals(value) || "-glob".equals(value) || "--".equals(value))) {
                                patternsStart = i + 1;
                                switchStatement.setString((ASTNode)at2);
                                break;
                            }
                        } else {
                            if (at2 instanceof StringLiteral) {
                                patternsStart = i + 1;
                                switchStatement.setString((ASTNode)at2);
                                break;
                            }
                            if (at2 instanceof TclAdvancedExecuteExpression) {
                                patternsStart = i + 1;
                                switchStatement.setString((ASTNode)at2);
                                break;
                            }
                        }
                        ++i;
                    }
                    if (patternsStart == -1 || patternsStart >= statement.getCount()) break block13;
                    at = statement.getAt(patternsStart);
                    if (!(at instanceof TclBlockExpression)) break block14;
                    TclBlockExpression tclBlockExpression = (TclBlockExpression)at;
                    processedArgument = tclBlockExpression.getProcessedArgument();
                    if (processedArgument != null && parser instanceof NewTclSourceParser) break block15;
                    List list = tclBlockExpression.parseBlockSimple(false);
                    Block bll = new Block(at.sourceStart(), at.sourceEnd());
                    switchStatement.acceptBlock(bll);
                    if (list == null) break block13;
                    for (ASTNode st : list) {
                        if (st instanceof Block) {
                            switchStatement.addChild((Block)st);
                            continue;
                        }
                        if (st instanceof TclBlockExpression) {
                            this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)st);
                            continue;
                        }
                        if (!(st instanceof TclStatement)) continue;
                        TclStatement stt = (TclStatement)st;
                        int i2 = 0;
                        while (i2 < stt.getCount()) {
                            Expression sttt = stt.getAt(i2);
                            if (sttt instanceof TclBlockExpression) {
                                this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)sttt);
                            }
                            ++i2;
                        }
                    }
                    break block13;
                }
                final Block bll = new Block(at.sourceStart(), at.sourceEnd());
                switchStatement.acceptBlock(bll);
                final NewTclSourceParser newParser = (NewTclSourceParser)parser;
                if (!(processedArgument instanceof TclArgumentList)) break block13;
                TclArgumentList list = (TclArgumentList)processedArgument;
                EList arguments = list.getArguments();
                TclParserUtils.traverse((List)arguments, (TclVisitor)new TclVisitor(){

                    public boolean visit(Script script) {
                        newParser.parse(script, bll);
                        return super.visit(script);
                    }
                });
                break block13;
            }
            int index = 0;
            int i = patternsStart;
            while (i < statement.getCount()) {
                Expression st = statement.getAt(patternsStart);
                if (st instanceof TclBlockExpression) {
                    this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)st);
                }
                ++index;
                ++i;
            }
        }
        return switchStatement;
    }

    private void parserBlockAddTo(ITclParser parser, TclSwitchStatement switchStatement, TclBlockExpression st) {
        Block block = new Block(st.sourceStart(), st.sourceEnd());
        String content = st.getBlock();
        if (content.startsWith("{") && content.endsWith("}")) {
            content = content.substring(1, content.length() - 1);
        }
        switchStatement.addChild(block);
        parser.parse(content, st.sourceStart() + 1 - parser.getStartPos(), (ASTNode)block);
    }
}

