/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.internal.ui.util.ViewerPane;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorer;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.HintTextGroup;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class NewSourceContainerWorkbookPage
extends BuildPathBasePage
implements BuildpathModifier.IBuildpathModifierListener {
    public static final String OPEN_SETTING = "org.eclipse.dltk.internal.ui.wizards.buildpaths.NewSourceContainerPage.openSetting";
    private ListDialogField fBuildpathList;
    private HintTextGroup fHintTextGroup;
    private DialogPackageExplorer fPackageExplorer;
    private IScriptProject fScriptProject;
    private final IPreferenceStore fStore;

    public NewSourceContainerWorkbookPage(ListDialogField BuildpathList, IRunnableContext context, IPreferenceStore store) {
        this.fBuildpathList = BuildpathList;
        this.fStore = store;
        this.fPackageExplorer = new DialogPackageExplorer(){

            protected IPreferenceStore getPreferenceStore() {
                return NewSourceContainerWorkbookPage.this.fStore;
            }
        };
        this.fHintTextGroup = new HintTextGroup(this.fPackageExplorer, context);
    }

    public void init(IScriptProject scriptProject) {
        this.fScriptProject = scriptProject;
        this.fHintTextGroup.setScriptProject(scriptProject);
        this.fPackageExplorer.setInput(scriptProject);
    }

    public Control getControl(Composite parent) {
        final int[] sashWeight = new int[]{60};
        final IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(OPEN_SETTING, true);
        ScrolledPageContent scrolledContent = new ScrolledPageContent(parent);
        Composite body = scrolledContent.getBody();
        body.setLayout((Layout)new GridLayout());
        final SashForm sashForm = new SashForm(body, 512);
        sashForm.setFont(sashForm.getFont());
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setContent(this.fPackageExplorer.createControl((Composite)pane));
        this.fPackageExplorer.setContentProvider();
        final ExpandableComposite excomposite = new ExpandableComposite((Composite)sashForm, 0, 18);
        excomposite.setFont(sashForm.getFont());
        excomposite.setText(NewWizardMessages.NewSourceContainerWorkbookPage_HintTextGroup_title);
        boolean isExpanded = preferenceStore.getBoolean(OPEN_SETTING);
        excomposite.setExpanded(isExpanded);
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite = NewSourceContainerWorkbookPage.this.getParentScrolledComposite((Control)excomposite);
                if (parentScrolledComposite != null) {
                    boolean expanded = excomposite.isExpanded();
                    NewSourceContainerWorkbookPage.this.adjustSashForm(sashWeight, sashForm, expanded);
                    preferenceStore.setValue(NewSourceContainerWorkbookPage.OPEN_SETTING, expanded);
                }
            }
        });
        excomposite.setClient((Control)this.fHintTextGroup.createControl((Composite)excomposite));
        DialogPackageExplorerActionGroup actionGroup = new DialogPackageExplorerActionGroup(this.fHintTextGroup, this);
        Composite outputLocation = new Composite(body, 0);
        outputLocation.setLayout((Layout)new GridLayout(2, false));
        outputLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtil.doDefaultLayout(outputLocation, new DialogField[0], true, -1, -1);
        ToolBarManager tbm = actionGroup.createLeftToolBarManager(pane);
        pane.setTopCenter(null);
        pane.setTopLeft((Control)tbm.getControl());
        tbm = actionGroup.createLeftToolBar(pane);
        pane.setTopRight((Control)tbm.getControl());
        this.fHintTextGroup.setActionGroup(actionGroup);
        this.fPackageExplorer.setActionGroup(actionGroup);
        actionGroup.addListener(this.fHintTextGroup);
        sashForm.setWeights(new int[]{60, 40});
        this.adjustSashForm(sashWeight, sashForm, excomposite.isExpanded());
        GridData gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gd);
        parent.layout(true);
        return scrolledContent;
    }

    private void adjustSashForm(int[] sashWeight, SashForm sashForm, boolean isExpanded) {
        if (isExpanded) {
            int upperWeight = sashWeight[0];
            sashForm.setWeights(new int[]{upperWeight, 100 - upperWeight});
        } else {
            sashWeight[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    public List getSelection() {
        ArrayList<BPListElement> selectedList = new ArrayList<BPListElement>();
        IScriptProject project = this.fHintTextGroup.getScriptProject();
        try {
            List list = this.fHintTextGroup.getSelection().toList();
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            int i = 0;
            while (i < list.size()) {
                IBuildpathEntry entry;
                BPListElement cpElement;
                Object obj = list.get(i);
                if (obj instanceof IProjectFragment) {
                    IProjectFragment element = (IProjectFragment)obj;
                    cpElement = BuildpathModifier.getBuildpathEntry(existingEntries, element);
                    selectedList.add(cpElement);
                } else if (obj instanceof IScriptProject && (entry = BuildpathModifier.getBuildpathEntryFor(project.getPath(), project, 3)) != null) {
                    cpElement = BPListElement.createFromExisting(entry, project);
                    selectedList.add(cpElement);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new ArrayList();
        }
        return selectedList;
    }

    public void setSelection(List selection, boolean expand) {
        if (selection.size() == 0) {
            return;
        }
        ArrayList<BPListElement> cpEntries = new ArrayList<BPListElement>();
        int i = 0;
        while (i < selection.size()) {
            BPListElementAttribute attribute;
            BPListElement element;
            Object obj = selection.get(i);
            if (obj instanceof BPListElement) {
                BPListElement element2 = (BPListElement)obj;
                if (element2.getEntryKind() == 3) {
                    cpEntries.add(element2);
                }
            } else if (obj instanceof BPListElementAttribute && (element = (attribute = (BPListElementAttribute)obj).getParent()).getEntryKind() == 3) {
                cpEntries.add(element);
            }
            ++i;
        }
        List list = this.fBuildpathList.getElements();
        IBuildpathEntry[] entries = new IBuildpathEntry[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            BPListElement entry = (BPListElement)list.get(i2);
            entries[i2] = entry.getBuildpathEntry();
            ++i2;
        }
        try {
            this.fScriptProject.setRawBuildpath(entries, null);
            this.fPackageExplorer.refresh();
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        this.fPackageExplorer.setSelection(cpEntries);
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    public void buildpathEntryChanged(List newEntries) {
        this.fBuildpathList.setElements(newEntries);
    }
}

