/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.testing;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.testing.util.NumberUtils;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestingEngineDetectResult;
import org.eclipse.dltk.utils.NatureExtensionManager;

public final class TestingEngineManager
extends NatureExtensionManager {
    private static final String EXTENSION_POINT = "org.eclipse.dltk.testing.engine";
    private static final String PRIORITY_ATTR = "priority";
    private final Comparator descriptorComparator;
    private static TestingEngineManager instance = null;
    static /* synthetic */ Class class$0;

    private TestingEngineManager() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.testing.ITestingEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(EXTENSION_POINT, (Class)clazz);
        this.descriptorComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Descriptor descriptor1 = (Descriptor)o1;
                Descriptor descriptor2 = (Descriptor)o2;
                return descriptor1.priority - descriptor2.priority;
            }
        };
    }

    protected Object createDescriptor(IConfigurationElement confElement) {
        String strPriority = confElement.getAttribute(PRIORITY_ATTR);
        int priority = NumberUtils.toInt(strPriority);
        return new Descriptor(confElement, priority);
    }

    protected void initializeDescriptors(List descriptors) {
        Collections.sort(descriptors, this.descriptorComparator);
    }

    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        Descriptor engineDescriptor = (Descriptor)descriptor;
        return super.createInstanceByDescriptor((Object)engineDescriptor.element);
    }

    protected Object[] createEmptyResult() {
        return new ITestingEngine[0];
    }

    private static TestingEngineManager getInstance() {
        if (instance == null) {
            instance = new TestingEngineManager();
        }
        return instance;
    }

    public static ITestingEngine[] getEngines(String natureId) {
        return (ITestingEngine[])TestingEngineManager.getInstance().getInstances(natureId);
    }

    public static ITestingEngine getEngine(String engineId) {
        if (engineId != null) {
            ITestingEngine[] engines = (ITestingEngine[])TestingEngineManager.getInstance().getAllInstances();
            int i = 0;
            while (i < engines.length) {
                ITestingEngine engine = engines[i];
                if (engineId.equals(engine.getId())) {
                    return engine;
                }
                ++i;
            }
        }
        return null;
    }

    public static TestingEngineDetectResult detect(ITestingEngine[] engines, ISourceModule module) {
        IStatus infoStatus = null;
        ITestingEngine infoEngine = null;
        int i = 0;
        while (i < engines.length) {
            ITestingEngine engine = engines[i];
            IStatus status = engine.validateSourceModule(module);
            if (status != null) {
                if (status.isOK()) {
                    return new TestingEngineDetectResult(engine, status);
                }
                if (status.getSeverity() == 1 && infoStatus == null) {
                    infoStatus = status;
                    infoEngine = engine;
                }
            }
            ++i;
        }
        if (infoEngine != null) {
            return new TestingEngineDetectResult(infoEngine, infoStatus);
        }
        return null;
    }

    private static class Descriptor {
        final IConfigurationElement element;
        final int priority;

        public Descriptor(IConfigurationElement confElement, int priority) {
            this.element = confElement;
            this.priority = priority;
        }
    }
}

