/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.Messages;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.core.util.Util;

public class DLTKProblemReporter
extends AbstractProblemReporter
implements IProblemReporter {
    private IResource resource;
    private IProblemFactory factory;
    private boolean cleaned = false;

    public void reportProblem(IProblem problem) {
        try {
            String[] arguments;
            int severity = 0;
            if (problem.isError()) {
                severity = 2;
            } else if (problem.isWarning()) {
                severity = 1;
            }
            IMarker m = this.resource.createMarker("org.eclipse.dltk.core.problem");
            m.setAttribute("lineNumber", problem.getSourceLineNumber() + 1);
            m.setAttribute("message", (Object)problem.getMessage());
            m.setAttribute("severity", severity);
            m.setAttribute("priority", 1);
            m.setAttribute("charStart", problem.getSourceStart());
            m.setAttribute("charEnd", problem.getSourceEnd());
            if (problem.getID() != 0) {
                m.setAttribute("id", problem.getID());
            }
            if ((arguments = problem.getArguments()) != null && arguments.length != 0) {
                m.setAttribute("arguments", (Object)Util.getProblemArgumentsForMarker(arguments));
            }
        }
        catch (CoreException e) {
            DLTKCore.error("reportProblem", e);
        }
    }

    protected IProblemFactory getProblemFactory() {
        return this.factory;
    }

    public DLTKProblemReporter(IResource resource, IProblemFactory factory) {
        if (resource == null) {
            throw new NullPointerException(Messages.DLTKProblemReporter_resourceCannotBeNull);
        }
        if (factory == null) {
            throw new NullPointerException(Messages.DLTKProblemReporter_factoryCannotBeNull);
        }
        this.resource = resource;
        this.factory = factory;
    }

    public void clearMarkers() {
        if (this.resource != null) {
            block4: {
                try {
                    if (this.resource.findMarkers("org.eclipse.dltk.core.problem", true, 2).length > 0) {
                        this.resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            this.cleaned = true;
        }
    }

    public boolean isMarkersCleaned() {
        return this.cleaned;
    }
}

