/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;

public class ArrayInitializer
extends Expression {
    private List items;
    private List commas;
    private int LB = -1;
    private int RB = -1;

    public ArrayInitializer(ASTNode parent) {
        super(parent);
    }

    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public List getCommas() {
        return this.commas;
    }

    public void setCommas(List commas) {
        this.commas = commas;
    }

    public int getLB() {
        return this.LB;
    }

    public void setLB(int pos) {
        this.LB = pos;
    }

    public int getRB() {
        return this.RB;
    }

    public void setRB(int pos) {
        this.RB = pos;
    }

    public String toSourceString(String indentionString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LB > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RB > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.items.size() == 0 || this.commas.size() == this.items.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (i < this.items.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            ISourceable item = (ISourceable)this.items.get(i);
            buffer.append(item.toSourceString(indentionString));
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

