/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.ITypeInferencer;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class DLTKTypeInferenceEngine
implements ITypeInferencer {
    private static final String NATURE = "nature";
    private static final String TYPE_EVALUATORS = "org.eclipse.dltk.core.typeEvaluators";
    private static final Map evaluatorsByNatures = new HashMap();
    private static ThreadLocal<List<AbstractTypeGoal>> goals;

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(TYPE_EVALUATORS);
        IExtension[] ext = extensionPoint.getExtensions();
        int a = 0;
        while (a < ext.length) {
            IConfigurationElement[] elements = ext[a].getConfigurationElements();
            IConfigurationElement myElement = elements[0];
            try {
                String nature = myElement.getAttribute(NATURE);
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)evaluatorsByNatures.get(nature);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    evaluatorsByNatures.put(nature, list);
                }
                list.add(myElement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++a;
        }
        goals = new ThreadLocal<List<AbstractTypeGoal>>(){

            @Override
            protected List<AbstractTypeGoal> initialValue() {
                return new ArrayList<AbstractTypeGoal>();
            }
        };
    }

    private void flattenTypes(AmbiguousType type, Set typeSet) {
        IEvaluatedType[] possibleTypes = type.getPossibleTypes();
        int cnt = 0;
        int max = possibleTypes.length;
        while (cnt < max) {
            if (possibleTypes[cnt] instanceof AmbiguousType) {
                this.flattenTypes((AmbiguousType)possibleTypes[cnt], typeSet);
            } else {
                typeSet.add(possibleTypes[cnt]);
            }
            ++cnt;
        }
    }

    private void searchTypeDeclarations(IScriptProject dltkProject, String patternString, TypeNameMatchRequestor requestor) {
        try {
            int includeMask = 1;
            IDLTKSearchScope scope = SearchEngine.createSearchScope(dltkProject, includeMask |= 0xE);
            SearchEngine engine = new SearchEngine();
            String typeName = "";
            typeName = patternString.indexOf("::") != -1 ? patternString.substring(patternString.indexOf("::") + 2) : patternString;
            engine.searchAllTypeNames(null, 0, typeName.toCharArray(), 0, 0, scope, requestor, 3, null);
        }
        catch (CoreException cxcn) {
            cxcn.printStackTrace();
        }
    }

    private void collectSuperClasses(IScriptProject project, String typeName, Set superClassSet) {
        final HashSet iTypeSet = new HashSet();
        this.searchTypeDeclarations(project, typeName, new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                iTypeSet.add(match.getType());
            }
        });
        if (!iTypeSet.isEmpty()) {
            for (IType itype : iTypeSet) {
                if (!itype.exists()) continue;
                try {
                    String[] superClasses = itype.getSuperClasses();
                    if (superClasses == null) continue;
                    int cnt = 0;
                    int max = superClasses.length;
                    while (cnt < max) {
                        if (!superClassSet.contains(superClasses[cnt])) {
                            superClassSet.add(superClasses[cnt]);
                            this.collectSuperClasses(project, superClasses[cnt], superClassSet);
                        }
                        ++cnt;
                    }
                }
                catch (ModelException mxcn) {
                    mxcn.printStackTrace();
                }
            }
        }
    }

    private void reduceTypes(BasicContext context, Set typeSet) {
        HashSet superClassSet = new HashSet();
        for (IEvaluatedType type : typeSet) {
            this.collectSuperClasses(context.getSourceModule().getScriptProject(), type.getTypeName(), superClassSet);
        }
        if (!superClassSet.isEmpty()) {
            Iterator iter = typeSet.iterator();
            while (iter.hasNext()) {
                IEvaluatedType type;
                type = (IEvaluatedType)iter.next();
                if (!superClassSet.contains(type.getTypeName())) continue;
                iter.remove();
            }
        }
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal, int time) {
        String nature = goal.getContext().getLangNature();
        List list = (List)evaluatorsByNatures.get(nature);
        if (list != null) {
            List<AbstractTypeGoal> threadGoals = goals.get();
            if (threadGoals.size() > 32) {
                return null;
            }
            threadGoals.add(goal);
            try {
                IEvaluatedType iEvaluatedType = this.evaluateType(goal, time, list);
                return iEvaluatedType;
            }
            finally {
                threadGoals.remove(threadGoals.size() - 1);
            }
        }
        return null;
    }

    private IEvaluatedType evaluateType(AbstractTypeGoal goal, int time, List list) {
        HashSet<IEvaluatedType> typeSet = new HashSet<IEvaluatedType>();
        for (IConfigurationElement element : list) {
            ITypeInferencer ti;
            try {
                ti = (ITypeInferencer)element.createExecutableExtension("evaluator");
            }
            catch (CoreException e) {
                e.printStackTrace();
                continue;
            }
            IEvaluatedType type = ti.evaluateType(goal, time);
            if (type == null || type instanceof UnknownType) continue;
            if (type instanceof AmbiguousType) {
                this.flattenTypes((AmbiguousType)type, typeSet);
                continue;
            }
            typeSet.add(type);
        }
        if (typeSet.size() > 1 && goal.getContext() instanceof BasicContext) {
            this.reduceTypes((BasicContext)goal.getContext(), typeSet);
        }
        if (typeSet.size() == 1) {
            return (IEvaluatedType)typeSet.iterator().next();
        }
        if (typeSet.size() > 1) {
            return new AmbiguousType(typeSet.toArray(new IEvaluatedType[typeSet.size()]));
        }
        return null;
    }
}

