/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist.completion;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IClassReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.core.codeassist.AssitUtils;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.core.mixin.JavaScriptMixinModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptCompletionEngine
extends ScriptCompletionEngine
implements JSCompletionEngine {
    private boolean useEngine = true;

    @Override
    public boolean isUseEngine() {
        return this.useEngine;
    }

    @Override
    public void setUseEngine(boolean useEngine) {
        this.useEngine = useEngine;
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public void complete(IModuleSource cu, int position, int i) {
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        if (position > 0) {
            if (content.charAt(position - 1) == '.') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
            if (position > 0 && content.charAt(position - 1) == '=') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
        }
        AssitUtils.PositionCalculator calculator = new AssitUtils.PositionCalculator(content, position, false);
        ISourceModule module = cu instanceof ISourceModule ? (ISourceModule)cu : null;
        ReferenceResolverContext buildContext = AssitUtils.buildContext(module, position, content, cu.getFileName());
        HostCollection collection = buildContext.getHostCollection();
        String startPart = calculator.getCompletion();
        this.setSourceRange(position - startPart.length(), position);
        if (calculator.isMember()) {
            this.doCompletionOnMember(calculator, buildContext, cu, position, content, position, collection);
        } else {
            this.doGlobalCompletion(buildContext, cu, position, position, collection, startPart);
        }
        this.requestor.endReporting();
    }

    private void doGlobalCompletion(ReferenceResolverContext buildContext, IModuleSource cu, int position, int pos, HostCollection collection, String completion) {
        String[] choices;
        HashSet<String> completedNames = new HashSet<String>();
        char[] token = completion.toCharArray();
        HashMap<String, Object> names = new HashMap<String, Object>();
        Set resolveGlobals = buildContext.resolveGlobals(completion);
        Iterator<Object> it = resolveGlobals.iterator();
        HashSet<IReference> classes = new HashSet<IReference>();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IReference)) continue;
            IReference iReference = (IReference)o;
            if (iReference instanceof IClassReference) {
                classes.add(iReference);
                continue;
            }
            this.putAndCheckDuplicateReference(names, iReference);
        }
        names.remove("!!!returnValue");
        this.completeFromMap(position, completion, names);
        if (names.size() > 0) {
            choices = new String[names.size()];
            boolean bl = false;
            for (String string : names.keySet()) {
                choices[++var14_16] = string;
            }
            this.findLocalVariables(token, choices, true, false);
        }
        if (classes.size() > 0) {
            choices = new String[classes.size()];
            boolean bl = false;
            for (IReference iReference : classes) {
                choices[++var14_18] = iReference.getName();
            }
            this.findElements(token, choices, true, false, 7);
        }
        if (this.useEngine) {
            this.doCompletionOnKeyword(position, pos, completion);
            JavaScriptMixinModel instance = JavaScriptMixinModel.getInstance();
            String[] stringArray = instance.findElements(String.valueOf(MixinModel.SEPARATOR) + completion);
            ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
            HashSet<String> hashSet = new HashSet<String>();
            int a = 0;
            while (a < stringArray.length) {
                Object[] allObjects;
                IMixinElement mixinElement;
                String string = stringArray[a];
                if (string.lastIndexOf(MixinModel.SEPARATOR) <= 0 && (mixinElement = instance.getRawModel().get(string)) != null && (allObjects = mixinElement.getObjects(buildContext.getModule())).length > 0) {
                    int i = 0;
                    while (i < allObjects.length) {
                        Object object = allObjects[i];
                        if (object instanceof IModelElement) {
                            IModelElement el = (IModelElement)object;
                            int elementType = el.getElementType();
                            if (elementType == 9) {
                                arrayList.add((IMethod)el);
                            } else if (elementType == 8) {
                                hashSet.add(el.getElementName());
                            }
                        } else if (object == null) {
                            hashSet.add(mixinElement.getLastKeySegment());
                        }
                        ++i;
                    }
                }
                ++a;
            }
            for (IMethod method : arrayList) {
                completedNames.add(method.getElementName());
            }
            this.findMethods(token, true, arrayList);
            if (!hashSet.isEmpty()) {
                completedNames.addAll(hashSet);
                String[] choices2 = hashSet.toArray(new String[hashSet.size()]);
                this.findLocalVariables(token, choices2, true, false);
            }
        }
        Map<String, IReference> rfs = collection.getReferences();
        while (collection.getParent() != null) {
            collection = collection.getParent();
            Map<String, IReference> map = collection.getReferences();
            for (Object object : map.keySet()) {
                String string;
                if (!(object instanceof String) || rfs.containsKey(string = (String)object)) continue;
                rfs.put(string, map.get(string));
            }
        }
        for (Object object : rfs.keySet()) {
            String string;
            if (!(object instanceof String) || completedNames.contains(string = (String)object)) continue;
            names.put(string, rfs.get(string));
        }
        names.remove("!!!returnValue");
        if (names.size() > 0) {
            this.completeFromMap(position, completion, names);
        }
    }

    private void doCompletionOnMember(AssitUtils.PositionCalculator calculator, ReferenceResolverContext buildContext, IModuleSource cu, int position, String content, int pos, HostCollection collection) {
        String completionPart = calculator.getCompletionPart();
        String corePart = calculator.getCorePart();
        HashMap<String, Object> dubR = new HashMap<String, Object>();
        Set resolveGlobals = buildContext.resolveGlobals(String.valueOf(corePart) + '.');
        for (Object o : resolveGlobals) {
            if (!(o instanceof IReference)) continue;
            IReference r = (IReference)o;
            this.putAndCheckDuplicateReference(dubR, r);
        }
        this.completeFromMap(position, completionPart, dubR);
        Set<IReference> references = collection.queryElements(corePart, true);
        if (!references.isEmpty()) {
            HashSet<IReference> fields = new HashSet<IReference>();
            for (IReference mnext : references) {
                IReference proto = mnext.getPrototype(true);
                if (proto != null) {
                    AbstractCollection protos = new LinkedHashSet<IReference>();
                    while (proto != null && !protos.contains(proto)) {
                        protos.add(proto);
                        proto = proto.getPrototype(false);
                    }
                    protos = new LinkedList(protos);
                    Collections.reverse((List)((Object)protos));
                    for (IReference proto1 : protos) {
                        fields.addAll(proto1.getChilds(true));
                    }
                }
                if (mnext.isFunctionRef()) {
                    IReference result = mnext.getChild("!!!returnValue", true);
                    if (result != null) {
                        fields.addAll(result.getChilds(true));
                        continue;
                    }
                    fields.addAll(mnext.getChilds(true));
                    continue;
                }
                fields.addAll(mnext.getChilds(true));
            }
            for (IReference name : fields) {
                String refa = name.getName();
                dubR.put(refa, name);
            }
            this.completeFromMap(position, completionPart, dubR);
        }
    }

    private void putAndCheckDuplicateReference(Map<String, Object> dubR, IReference r) {
        Object put = dubR.put(r.getName(), r);
        if (put instanceof IReference) {
            if (r instanceof CombinedOrReference) {
                ((CombinedOrReference)r).addReference((IReference)put);
            } else if (put instanceof CombinedOrReference) {
                ((CombinedOrReference)put).addReference(r);
                dubR.put(r.getName(), put);
            } else {
                CombinedOrReference or = new CombinedOrReference();
                or.addReference(r);
                or.addReference((IReference)put);
                dubR.put(r.getName(), or);
            }
        }
    }

    private void completeFromMap(int position, String completionPart, Map<String, Object> dubR) {
        this.requestor.acceptContext(new CompletionContext());
        this.setSourceRange(position - completionPart.length(), position);
        Iterator<Object> iterator = dubR.values().iterator();
        while (iterator.hasNext()) {
            String name;
            CompletionProposal createProposal;
            Object next = iterator.next();
            if (next instanceof SelfCompletingReference) {
                SelfCompletingReference cm = (SelfCompletingReference)next;
                if (JavaScriptCompletionEngine.startsWith(cm, completionPart)) {
                    createProposal = this.createProposal(cm.getKind(), this.actualCompletionPosition);
                    name = cm.getName();
                    createProposal.setName(name);
                    createProposal.setCompletion(name);
                    createProposal.setExtraInfo((Object)cm);
                    createProposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                    this.requestor.accept(createProposal);
                }
                iterator.remove();
                continue;
            }
            if (!(next instanceof IReference)) continue;
            IReference ref = (IReference)next;
            if (JavaScriptCompletionEngine.startsWith(ref, completionPart)) {
                createProposal = this.createProposal(ref.isFunctionRef() ? 5 : 4, this.actualCompletionPosition);
                name = ref.getName();
                createProposal.setName(name);
                createProposal.setCompletion(name);
                if (ref.isFunctionRef()) {
                    Iterator<IReference> childs = ref.getChilds(true).iterator();
                    ArrayList<String> al = new ArrayList<String>();
                    while (childs.hasNext()) {
                        IReference o = childs.next();
                        if (!(o instanceof StandardSelfCompletingReference) || ((StandardSelfCompletingReference)o).getParameterIndex() == -1) continue;
                        int index = ((StandardSelfCompletingReference)o).getParameterIndex();
                        while (index >= al.size()) {
                            al.add(null);
                        }
                        al.set(index, ((StandardSelfCompletingReference)o).getName());
                    }
                    if (al.size() > 0) {
                        createProposal.setParameterNames(al.toArray(new String[al.size()]));
                    }
                }
                createProposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                this.requestor.accept(createProposal);
            }
            iterator.remove();
        }
    }

    private static boolean startsWith(IReference reference, String prefix) {
        return reference.getName().toLowerCase().startsWith(prefix.toLowerCase());
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List<IMethod> methods, int kind) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                String qname;
                IMethod method = methods.get(i);
                String name = qname = this.processMethodName(method, tok);
                if (DLTKCore.DEBUG_COMPLETION) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals((char[])token, (char[])name.toCharArray(), (boolean)false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        String[] arguments = null;
                        try {
                            arguments = method.getParameterNames();
                        }
                        catch (ModelException modelException) {}
                        if (arguments != null && arguments.length > 0) {
                            proposal.setParameterNames(arguments);
                        }
                        if (kind == 5) {
                            StringBuffer sig = new StringBuffer();
                            sig.append(method.getElementName());
                            sig.append('(');
                            if (arguments != null) {
                                int a = 0;
                                while (a < arguments.length) {
                                    sig.append('L');
                                    sig.append("Object");
                                    sig.append(';');
                                    ++a;
                                }
                            }
                            sig.append(')');
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setExtraInfo((Object)method);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void doCompletionOnKeyword(int position, int pos, String startPart) {
        String[] keywords = JavaScriptKeywords.getJavaScriptKeywords();
        this.findKeywords(startPart.toCharArray(), keywords, true);
    }
}

