/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ReplacementBuffer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public abstract class LinkedModeScriptCompletionProposal
extends LazyScriptCompletionProposal {
    private IRegion fSelectedRegion;
    private ReplacementBuffer replacementBuffer;

    public LinkedModeScriptCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == this.getOpenTrigger()) {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        int replacementOffset = this.getReplacementOffset();
        int exit = replacementOffset + this.getReplacementString().length();
        if (this.replacementBuffer != null && this.replacementBuffer.hasArguments() && this.getTextViewer() != null) {
            int cursor = this.getCursorPosition();
            try {
                char[] exitTriggers;
                LinkedModeModel model = new LinkedModeModel();
                for (ReplacementBuffer.Argument region : this.replacementBuffer.arguments) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int argOffset = replacementOffset + region.offset;
                    if (region.relativeToCursor) {
                        argOffset += cursor;
                    }
                    group.addPosition(new LinkedPosition(document, argOffset, region.length, -1));
                    model.addGroup(group);
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), exit, 0, Integer.MAX_VALUE);
                char exitTrigger = this.getExitTrigger();
                if (exitTrigger != '\u0000') {
                    ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractScriptCompletionProposal.ExitPolicy(exitTrigger, document));
                }
                if ((exitTriggers = this.getExitTriggers()) != null) {
                    int i = 0;
                    while (i < exitTriggers.length) {
                        ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractScriptCompletionProposal.ExitPolicy(exitTriggers[i], document));
                        ++i;
                    }
                }
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.fSelectedRegion = new Region(replacementOffset + this.getCursorPosition(), 0);
        }
    }

    protected abstract char getOpenTrigger();

    protected char getExitTrigger() {
        return '\u0000';
    }

    protected char[] getExitTriggers() {
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    protected final String computeReplacementString() {
        this.replacementBuffer = new ReplacementBuffer();
        this.computeReplacement(this.replacementBuffer);
        return this.replacementBuffer.toString();
    }

    protected abstract void computeReplacement(ReplacementBuffer var1);
}

