/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.ICodeSelection;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.utils.ArrayIterator;
import org.eclipse.dltk.utils.MultiArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodeSelection
implements ICodeSelection {
    @Nullable
    private final IModelElement[] modelElements;
    @Nullable
    private final Object[] foreignElements;
    @Nullable
    private final Map<Object, ISourceRange> ranges;

    public CodeSelection(IModelElement[] modelElements, Object[] foreignElements, Map<Object, ISourceRange> ranges) {
        Assert.isLegal((modelElements != null || foreignElements != null ? 1 : 0) != 0);
        if (modelElements != null) {
            Assert.isLegal((modelElements.length != 0 ? 1 : 0) != 0);
        }
        if (foreignElements != null) {
            Assert.isLegal((foreignElements.length != 0 ? 1 : 0) != 0);
        }
        this.modelElements = modelElements;
        this.foreignElements = foreignElements;
        this.ranges = ranges;
    }

    @Override
    public int size() {
        return (this.modelElements != null ? this.modelElements.length : 0) + (this.foreignElements != null ? this.foreignElements.length : 0);
    }

    @Override
    public Object[] toArray() {
        if (this.modelElements != null && this.foreignElements == null) {
            return this.modelElements;
        }
        if (this.modelElements == null && this.foreignElements != null) {
            return this.foreignElements;
        }
        Object[] result = new Object[this.modelElements.length + this.foreignElements.length];
        System.arraycopy(this.modelElements, 0, result, 0, this.modelElements.length);
        System.arraycopy(this.foreignElements, 0, result, this.modelElements.length, this.foreignElements.length);
        return result;
    }

    @Override
    public List<Object> toList() {
        if (this.modelElements != null && this.foreignElements == null) {
            return Arrays.asList(this.modelElements);
        }
        if (this.modelElements == null && this.foreignElements != null) {
            return Arrays.asList(this.foreignElements);
        }
        ArrayList<Object> result = new ArrayList<Object>(this.modelElements.length + this.foreignElements.length);
        Collections.addAll(result, this.modelElements);
        Collections.addAll(result, this.foreignElements);
        return result;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.modelElements != null && this.foreignElements == null) {
            return new ArrayIterator<Object>(this.modelElements);
        }
        if (this.modelElements == null && this.foreignElements != null) {
            return new ArrayIterator<Object>(this.foreignElements);
        }
        return new MultiArrayIterator<Object>(this.modelElements, this.foreignElements);
    }

    @Override
    public List<IModelElement> getModelElements() {
        return this.modelElements != null ? Arrays.asList(this.modelElements) : Collections.emptyList();
    }

    @Override
    public ISourceRange rangeOf(Object element) {
        return this.ranges != null ? this.ranges.get(element) : null;
    }
}

