/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptUtils;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.infoviews.AbstractInfoView;
import org.eclipse.dltk.ui.infoviews.InfoViewMessages;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.osgi.framework.Bundle;

public abstract class AbstractDocumentationView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "AbstractDocumentationView.error.doNotWarn";
    private static final boolean WARNING_DIALOG_ENABLED = false;
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x20L | 0x4000L | 1L | 2L | 0x10L | 0x200000L;
    private Browser fBrowser;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private static String fgStyleSheet;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;
    private RGB fForegroundColorRGB;

    @Override
    protected void internalCreatePartControl(Composite parent) {
        try {
            this.fBrowser = new Browser(parent, 0);
            this.fIsUsingBrowserWidget = true;
        }
        catch (SWTError sWTError) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean doNotWarn = store.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    AbstractDocumentationView.this.setInput(AbstractDocumentationView.this.fText.getText());
                }
            });
        }
        AbstractDocumentationView.initStyleSheet();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected abstract String getNature();

    private static void initStyleSheet() {
        Bundle bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/DocumentationViewStyleSheet.css");
        if (styleSheetURL == null) {
            return;
        }
        try {
            styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(200);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            fgStyleSheet = HTMLPrinter.convertTopLevelFont(buffer.toString(), fontData);
        }
        catch (IOException ex) {
            DLTKUIPlugin.log(ex);
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
    }

    @Override
    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    @Override
    protected IAction getCopyToClipboardAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return super.getCopyToClipboardAction();
    }

    @Override
    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
        this.fForegroundColorRGB = color.getRGB();
    }

    @Override
    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
        if (this.getInput() == null) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.insertPageProlog(buffer, 0, this.fBackgroundColorRGB, this.fForegroundColorRGB, fgStyleSheet);
            this.setInput(buffer.toString());
        } else {
            this.setInput(this.computeInput(this.getInput()));
        }
    }

    @Override
    protected String getBackgroundColorKey() {
        return "org.eclipse.dltk.ui.ScriptdocView.backgroundColor";
    }

    @Override
    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    @Override
    protected Object computeInput(Object input) {
        if (this.getControl() != null) {
            if (input instanceof AbstractInfoView.KeywordInput) {
                return this.getScriptdocHtml((AbstractInfoView.KeywordInput)input);
            }
            if (input instanceof ModelElementArray) {
                ModelElementArray array = (ModelElementArray)input;
                return this.getScriptdocHtmlDetailed(array.getElements());
            }
            if (input instanceof IModelElement) {
                IModelElement je = (IModelElement)input;
                switch (je.getElementType()) {
                    case 5: {
                        try {
                            ISourceModule module = (ISourceModule)je;
                            return this.getScriptdocHtmlList(module.getChildren());
                        }
                        catch (ModelException modelException) {
                            return null;
                        }
                    }
                }
                return this.getScriptdocHtml(je);
            }
        }
        return null;
    }

    @Override
    protected void setInput(Object input) {
        String javadocHtml = (String)input;
        if (this.fIsUsingBrowserWidget) {
            if (javadocHtml != null && javadocHtml.length() > 0) {
                boolean RTL;
                boolean bl = RTL = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (RTL) {
                    StringBuffer buffer = new StringBuffer(javadocHtml);
                    HTMLPrinter.insertStyles(buffer, new String[]{"direction:rtl"});
                    javadocHtml = buffer.toString();
                }
            }
            this.fBrowser.setText(javadocHtml);
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                javadocHtml = ((DefaultInformationControl.IInformationPresenterExtension)this.fPresenter).updatePresentation((Drawable)this.getSite().getShell(), javadocHtml, this.fPresentation, size.width, size.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(javadocHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getScriptdocHtml(AbstractInfoView.KeywordInput keyword) {
        StringBuffer buffer = new StringBuffer();
        try {
            Reader reader = ScriptDocumentationAccess.getKeywordDocumentation(this.getNature(), keyword.getContext(), keyword.getValue());
            if (reader != null) {
                HTMLPrinter.addParagraph(buffer, reader);
            }
        }
        catch (ModelException ex) {
            DLTKUIPlugin.log(ex);
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, fgStyleSheet);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getScriptdocHtmlDetailed(Object[] result) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> nodocs = new ArrayList<String>();
        int i = 0;
        while (i < result.length) {
            Object member = result[i];
            Reader reader = ScriptDocumentationAccess.getHTMLContentReader(this.getNature(), member, true, true);
            if (reader != null) {
                buffer.append("<b>");
                buffer.append(this.getInfoText(member));
                buffer.append("</b>");
                HTMLPrinter.addParagraph(buffer, reader);
            } else if (member instanceof IModelElement) {
                nodocs.add(ScriptElementLabels.getDefault().getElementLabel((IModelElement)member, LABEL_FLAGS | Long.MIN_VALUE));
            }
            ++i;
        }
        if (!nodocs.isEmpty()) {
            Collections.sort(nodocs);
            HTMLPrinter.addParagraph(buffer, InfoViewMessages.ScriptdocView_noAttachedInformationHeader);
            HTMLPrinter.startBulletList(buffer);
            for (String s : nodocs) {
                HTMLPrinter.addBullet(buffer, s);
            }
            HTMLPrinter.endBulletList(buffer);
        }
        return this.addPrologeEpilog(buffer);
    }

    private String getScriptdocHtmlList(IModelElement[] result) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.startBulletList(buffer);
        int i = 0;
        while (i < result.length) {
            IModelElement curr = result[i];
            if (curr instanceof IMember) {
                IMember member = (IMember)curr;
                HTMLPrinter.addBullet(buffer, this.getInfoText(member));
            }
            ++i;
        }
        HTMLPrinter.endBulletList(buffer);
        return this.addPrologeEpilog(buffer);
    }

    private String getScriptdocHtml(IModelElement curr) {
        StringBuffer buffer = new StringBuffer();
        if (curr instanceof IMember) {
            IMember member = (IMember)curr;
            Reader reader = ScriptDocumentationAccess.getHTMLContentReader(this.getNature(), member, true, true);
            if (reader != null) {
                HTMLPrinter.addParagraph(buffer, reader);
            } else {
                HTMLPrinter.addParagraph(buffer, InfoViewMessages.ScriptdocView_noAttachedInformation);
            }
        }
        return this.addPrologeEpilog(buffer);
    }

    private String addPrologeEpilog(StringBuffer buffer) {
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, this.fBackgroundColorRGB, this.fForegroundColorRGB, fgStyleSheet);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected boolean isValidWorkbenchPart(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            String editorNature = ScriptUtils.getNatureId((Object)editor);
            if (editorNature != null) {
                return editorNature.equals(this.getNature());
            }
            ISourceModule sourceModule = EditorUtility.getEditorInputModelElement(editor, false);
            if (sourceModule != null) {
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)sourceModule);
                return toolkit != null && toolkit.getNatureId().equals(this.getNature());
            }
        }
        return false;
    }

    private String getInfoText(Object member) {
        if (member instanceof IModelElement) {
            return ScriptElementLabels.getDefault().getElementLabel((IModelElement)member, LABEL_FLAGS);
        }
        return null;
    }

    @Override
    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    @Override
    protected String getHelpContextId() {
        return "";
    }

    private class SelectAllAction
    extends Action {
        private Control fControl;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!AbstractDocumentationView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList(1);
        private Control fControl;

        public SelectionProvider(Control control) {
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

