/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors.outline;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.workbench.DecoratingPatternStyledCellLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineModel;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.outline.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.outline.QuickOutlineLabelProvider;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.editor.IFormPage;

public class QuickOutlineDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    public static final String ID_VIEWER = "org.eclipse.mylyn.internal.tasks.ui.taskdata.quick";
    private TreeViewer viewer;
    private Text filterText;
    private Filter namePatternFilter;
    private OpenListener openListener;
    private final IWorkbenchWindow window;

    public QuickOutlineDialog(IWorkbenchWindow window) {
        super(window.getShell(), 16, true, true, true, true, true, null, null);
        this.window = window;
        this.setInfoText(Messages.QuickOutlineDialog_Press_Esc_Info_Text);
        this.create();
    }

    public boolean close() {
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.createViewer(parent);
        this.createUIListenersTreeViewer();
        this.addDisposeListener(this);
        return this.viewer.getControl();
    }

    private void createViewer(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.viewer = this.createCommonViewer((Composite)composite);
        this.openListener = new OpenListener((Viewer)this.viewer);
        this.viewer.addOpenListener((IOpenListener)this.openListener);
        this.viewer.getTree().addMouseListener((MouseListener)this.openListener);
        this.namePatternFilter = new Filter();
        this.namePatternFilter.setIncludeLeadingWildcard(true);
        this.viewer.addFilter((ViewerFilter)this.namePatternFilter);
        AbstractTaskEditorPage taskEditorPage = this.getTaskEditorPage();
        if (taskEditorPage != null) {
            try {
                this.viewer.getControl().setRedraw(false);
                TaskEditorOutlineNode root = TaskEditorOutlineNode.parse(taskEditorPage.getModel().getTaskData(), true);
                this.viewer.setInput((Object)new TaskEditorOutlineModel(root));
                this.viewer.expandAll();
                TaskEditorOutlineNode attributesNode = root.getChild(TaskEditorOutlineNode.LABEL_ATTRIBUTES);
                if (attributesNode != null) {
                    this.viewer.collapseToLevel((Object)attributesNode, -1);
                }
            }
            finally {
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    protected TreeViewer createCommonViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 768);
        viewer.setUseHashlookup(true);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new TaskEditorOutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingPatternStyledCellLabelProvider((ILabelProvider)new QuickOutlineLabelProvider(), (ILabelDecorator)new TaskEditorOutlineLabelDecorator(), null));
        return viewer;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    private void createUIListenersTreeViewer() {
        final Tree tree = this.viewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickOutlineDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                QuickOutlineDialog.this.handleTreeViewerMouseUp(tree, e);
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlineDialog.this.gotoSelectedElement();
            }
        });
    }

    private void handleTreeViewerMouseUp(Tree tree, MouseEvent e) {
        if (tree.getSelectionCount() < 1 || e.button != 1 || !tree.equals(e.getSource())) {
            return;
        }
        TreeItem object = tree.getItem(new Point(e.x, e.y));
        TreeItem selection = tree.getSelection()[0];
        if (selection.equals(object)) {
            this.gotoSelectedElement();
        }
    }

    private Object getSelectedElement() {
        if (this.viewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    protected Point getDefaultSize() {
        return new Point(400, 300);
    }

    public boolean isFocusControl() {
        return this.viewer.getControl().isFocusControl() || this.filterText.isFocusControl();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filterText.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.viewer != null && this.viewer.getInput() != null;
    }

    public void setInput(Object input) {
        if (input != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(input));
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.viewer = null;
        this.filterText = null;
    }

    protected Control createTitleControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createUIWidgetFilterText(control);
        this.createUIListenersFilterText();
        return control;
    }

    private void createUIWidgetFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(768);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        this.dispose();
    }

    private void createUIListenersFilterText() {
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickOutlineDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    QuickOutlineDialog.this.viewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    QuickOutlineDialog.this.viewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    QuickOutlineDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filterText.addModifyListener(e -> {
            Object text = ((Text)e.widget).getText();
            int length = ((String)text).length();
            if (length > 0) {
                if (((String)text).charAt(length - 1) != '*') {
                    text = (String)text + "*";
                }
                if (((String)text).charAt(0) != '*') {
                    text = "*" + (String)text;
                }
            }
            this.setMatcherString((String)text, true);
        });
    }

    private void setMatcherString(String pattern, boolean update) {
        this.namePatternFilter.setPattern(pattern);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private void stringMatcherUpdated() {
        this.viewer.getControl().setRedraw(false);
        this.viewer.refresh();
        this.viewer.expandAll();
        this.selectFirstMatch();
        this.viewer.getControl().setRedraw(true);
    }

    protected AbstractTaskEditorPage getTaskEditorPage() {
        TaskEditor taskEditor;
        IFormPage formPage;
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editorPart = activePage.getActiveEditor();
        AbstractTaskEditorPage taskEditorPage = null;
        if (editorPart instanceof TaskEditor && (formPage = (taskEditor = (TaskEditor)editorPart).getActivePageInstance()) instanceof AbstractTaskEditorPage) {
            taskEditorPage = (AbstractTaskEditorPage)formPage;
        }
        return taskEditorPage;
    }

    private void selectFirstMatch() {
        Tree tree = this.viewer.getTree();
        Object element = this.findFirstMatchToPattern(tree.getItems());
        if (element != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findFirstMatchToPattern(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element != null && this.namePatternFilter.wordMatches(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findFirstMatchToPattern(item.getItems());
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public final class Filter
    extends PatternFilter {
        protected boolean wordMatches(String text) {
            return super.wordMatches(text);
        }
    }

    private class OpenListener
    implements IOpenListener,
    IDoubleClickListener,
    MouseListener {
        private final Viewer viewer;

        public OpenListener(Viewer viewer) {
            this.viewer = viewer;
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.setSelection(e);
        }

        public void mouseDown(MouseEvent e) {
            this.setSelection(e);
        }

        public void mouseUp(MouseEvent e) {
        }

        public void doubleClick(DoubleClickEvent event) {
            this.open(null);
        }

        public void open(OpenEvent event) {
            AbstractTaskEditorPage taskEditorPage = QuickOutlineDialog.this.getTaskEditorPage();
            if (taskEditorPage == null) {
                return;
            }
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            Object select = selection.getFirstElement();
            taskEditorPage.selectReveal(select);
        }

        private void setSelection(MouseEvent event) {
            try {
                Object selection = ((Tree)event.getSource()).getSelection()[0].getData();
                this.viewer.setSelection((ISelection)new StructuredSelection(selection));
                this.open(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final class TaskEditorOutlineLabelDecorator
    implements ILabelDecorator {
        public String decorateText(String text, Object element) {
            TaskEditorOutlineNode node;
            if (element instanceof TaskEditorOutlineNode && (node = (TaskEditorOutlineNode)element).getTaskRelation() != null) {
                return NLS.bind((String)Messages.QuickOutlineDialog_Node_Label_Decoration, (Object)text, (Object)node.getTaskRelation().toString());
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }
    }
}

