/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.debug.internal.ui.pinclone.DebugContextPinProvider;
import org.eclipse.cdt.debug.internal.ui.pinclone.DebugEventFilterService;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.WorkbenchPart;

public class PinViewHandler
extends AbstractHandler {
    private DebugContextPinProvider fProvider;
    private String fLastKnownDescription = "";
    private String fPinnedContextLabel = "";
    private IPartListener2 fPartListener;
    private static final Set<IViewPart> pinned = new HashSet<IViewPart>();
    private Image image;

    public PinViewHandler() {
        this.createPartListener();
    }

    private void createPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (pinned == null || !pinned.contains(part)) {
                    return;
                }
                pinned.remove(part);
                DebugEventFilterService.getInstance().removeDebugEventFilter(part);
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Event trigger = (Event)event.getTrigger();
        ToolItem toolItem = (ToolItem)trigger.widget;
        boolean selection = toolItem.getSelection();
        IViewPart viewPart = (IViewPart)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (selection) {
            this.fProvider = DebugEventFilterService.getInstance().addDebugEventFilter((IWorkbenchPart)viewPart, this.getActiveDebugContext(viewPart));
            if (this.fProvider != null) {
                this.fLastKnownDescription = ((WorkbenchPart)viewPart).getContentDescription();
                this.fPinnedContextLabel = this.getPinContextLabel(this.fProvider);
                PinCloneUtils.setPartContentDescription(viewPart, this.fPinnedContextLabel);
                this.disposeImage();
                this.updatePinContextColor(this.fProvider, toolItem);
                pinned.add(viewPart);
                viewPart.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
            }
        } else {
            this.fProvider = null;
            DebugEventFilterService.getInstance().removeDebugEventFilter((IWorkbenchPart)viewPart);
            this.disposeImage();
            this.updatePinContextColor(this.fProvider, toolItem);
            PinCloneUtils.setPartContentDescription(viewPart, this.fLastKnownDescription);
            pinned.remove(viewPart);
            viewPart.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        }
        return 0;
    }

    private void disposeImage() {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    protected ISelection getActiveDebugContext(IViewPart viewPart) {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(viewPart.getSite().getWorkbenchWindow());
        return contextService.getActiveContext();
    }

    private String getPinContextLabel(DebugContextPinProvider provider) {
        Object description = "";
        if (provider != null) {
            HashSet<String> labels = new HashSet<String>();
            for (IPinProvider.IPinElementHandle handle : provider.getPinHandles()) {
                String tmp = this.getLabel(handle);
                if (tmp == null || tmp.trim().length() == 0) continue;
                labels.add(tmp);
            }
            for (String label : labels) {
                if (label == null) continue;
                description = ((String)description).length() > 0 ? (String)description + ", " + label : label;
            }
        }
        return description;
    }

    private String getLabel(IPinProvider.IPinElementHandle handle) {
        String label = "";
        if (handle != null) {
            label = handle.getLabel();
        }
        return label;
    }

    private void updatePinContextColor(DebugContextPinProvider provider, ToolItem toolItem) {
        ImageDescriptor imageDesc = null;
        if (provider != null) {
            Iterator<IPinProvider.IPinElementHandle> itr;
            Set<IPinProvider.IPinElementHandle> handles = provider.getPinHandles();
            if (this.useMultiPinImage(handles)) {
                imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_multi.gif");
            }
            if (imageDesc == null && (itr = handles.iterator()).hasNext()) {
                IPinProvider.IPinElementHandle handle = itr.next();
                IPinProvider.IPinElementColorDescriptor desc = handle.getPinElementColorDescriptor();
                if (desc != null) {
                    imageDesc = desc.getToolbarIconDescriptor();
                }
                if (imageDesc == null && desc != null) {
                    int overlayColor = desc.getOverlayColor() % 3;
                    switch (overlayColor) {
                        case 0: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_g.gif");
                            break;
                        }
                        case 1: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_r.gif");
                            break;
                        }
                        case 2: {
                            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned_b.gif");
                        }
                    }
                }
            }
        }
        if (imageDesc == null) {
            imageDesc = CDTSharedImages.getImageDescriptor((String)"icons/obj16/toolbar_pinned.gif");
        }
        this.image = imageDesc.createImage();
        toolItem.setImage(this.image);
    }

    private boolean useMultiPinImage(Set<IPinProvider.IPinElementHandle> handles) {
        if (handles.size() <= 1) {
            return false;
        }
        int overlayColor = -1;
        ImageDescriptor imageDesc = null;
        for (IPinProvider.IPinElementHandle handle : handles) {
            IPinProvider.IPinElementColorDescriptor colorDesc = handle.getPinElementColorDescriptor();
            if (colorDesc == null) continue;
            ImageDescriptor descImageDesc = colorDesc.getToolbarIconDescriptor();
            if (imageDesc != null && !imageDesc.equals(descImageDesc)) {
                return true;
            }
            imageDesc = descImageDesc;
            int descOverlayColor = colorDesc.getOverlayColor();
            if (overlayColor != -1 && descOverlayColor != overlayColor) {
                return true;
            }
            overlayColor = descOverlayColor;
        }
        return false;
    }

    public void dispose() {
        pinned.clear();
        this.disposeImage();
    }

    public static Set<IViewPart> getPinnedViews() {
        return pinned;
    }
}

