/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.autotools.ui.editors.AcInitElement;
import org.eclipse.cdt.autotools.ui.editors.AutoconfEditorMessages;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfCaseConditionElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfCaseElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElifElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElseElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfForElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfIfElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroArgumentElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfRootElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfSelectElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfTokenizer;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfUntilElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfWhileElement;
import org.eclipse.cdt.autotools.ui.editors.parser.IAutoconfErrorHandler;
import org.eclipse.cdt.autotools.ui.editors.parser.IAutoconfMacroDetector;
import org.eclipse.cdt.autotools.ui.editors.parser.IAutoconfMacroValidator;
import org.eclipse.cdt.autotools.ui.editors.parser.InvalidMacroException;
import org.eclipse.cdt.autotools.ui.editors.parser.ParseException;
import org.eclipse.cdt.autotools.ui.editors.parser.Token;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class AutoconfParser {
    public static final String MISSING_SPECIFIER = "MissingSpecifier";
    public static final String INVALID_SPECIFIER = "InvalidSpecifier";
    public static final String INVALID_TERMINATION = "InvalidTermination";
    public static final String UNTERMINATED_CONSTRUCT = "UnterminatedConstruct";
    public static final String MISSING_CONDITION = "MissingCondition";
    public static final String INVALID_ELIF = "InvalidElif";
    public static final String INVALID_ELSE = "InvalidElse";
    public static final String INVALID_FI = "InvalidFi";
    public static final String INVALID_DONE = "InvalidDone";
    public static final String INVALID_ESAC = "InvalidEsac";
    public static final String INVALID_DO = "InvalidDo";
    public static final String INVALID_THEN = "InvalidThen";
    public static final String INVALID_IN = "InvalidIn";
    public static final String IMPROPER_CASE_CONDITION = "ImproperCaseCondition";
    public static final String UNTERMINATED_CASE_CONDITION = "UnterminatedCaseCondition";
    public static final String UNTERMINATED_INLINE_DOCUMENT = "UnterminatedInlineDocument";
    public static final String INCOMPLETE_INLINE_MARKER = "IncompleteInlineMarker";
    public static final String MISSING_INLINE_MARKER = "MissingInlineMarker";
    public static final String UNMATCHED_RIGHT_PARENTHESIS = "UnmatchedRightParenthesis";
    public static final String UNMATCHED_LEFT_PARENTHESIS = "UnmatchedLeftParenthesis";
    private IAutoconfErrorHandler errorHandler;
    private IAutoconfMacroValidator macroValidator;
    private AutoconfTokenizer tokenizer;
    private IAutoconfMacroDetector macroDetector;
    private static final String M4_BUILTINS = "define undefine defn pushdef popdef indir builtin ifdef ifelse shift reverse cond dumpdef traceon traceoff debugmode debugfile dnl changequote changecom changeword m4wrap include sinclude divert undivert divnum len index regexp substr translit patsubst format incr decr eval syscmd esyscmd sysval mkstemp maketemp errprint m4exit __file__ __line__ __program__ ";
    private static List<String> m4builtins = new ArrayList<String>();

    static {
        m4builtins.addAll(Arrays.asList(M4_BUILTINS.split(" ")));
    }

    public AutoconfParser(IAutoconfErrorHandler errorHandler, IAutoconfMacroDetector macroDetector, IAutoconfMacroValidator macroValidator) {
        this.errorHandler = errorHandler;
        this.macroDetector = macroDetector;
        this.macroValidator = macroValidator;
    }

    public AutoconfElement parse(IDocument document) {
        return this.parse(document, true);
    }

    public AutoconfElement parse(IDocument document, boolean useAutoconfQuotes) {
        this.tokenizer = new AutoconfTokenizer(document, this.errorHandler);
        if (useAutoconfQuotes) {
            this.tokenizer.setM4Quote("[", "]");
        }
        AutoconfRootElement root = new AutoconfRootElement();
        Token eof = this.parseTopLevel(root);
        root.setStartOffset(0);
        root.setDocument(document);
        this.setSourceEnd(root, eof);
        return root;
    }

    protected Token parseTopLevel(AutoconfElement parent) {
        while (true) {
            try {
                while (true) {
                    this.parseStatement(parent);
                }
            }
            catch (BlockEndCondition e) {
                Token token;
                if ((token = this.tokenizer.peekToken()).getType() != 0) continue;
                return token;
            }
            break;
        }
    }

    protected void parseBlock(AutoconfElement parent, Token open, AutoconfElement block) throws BlockEndCondition {
        Token token;
        parent.addChild(block);
        this.setSourceStart(block, open);
        try {
            token = this.parseBlockExpression(open, block);
        }
        catch (BlockEndCondition e) {
            this.setSourceEndBefore(block, e.getToken());
            throw e;
        }
        if (token.getType() != 0) {
            try {
                while (true) {
                    this.parseStatement(block);
                }
            }
            catch (BlockEndCondition e) {
                this.setSourceEnd(block, e.getToken());
                return;
            }
        }
        this.setSourceEnd(block, token);
    }

    private Token parseBlockExpression(Token open, AutoconfElement block) throws BlockEndCondition {
        Token token;
        try {
            if (block instanceof AutoconfIfElement || block instanceof AutoconfElifElement || block instanceof AutoconfCaseElement || block instanceof AutoconfWhileElement) {
                token = this.parseExpression(block);
            } else if (block instanceof AutoconfForElement) {
                token = this.parseForExpression(block);
            } else {
                return open;
            }
            block.setVar(this.getTokenSpanTextBetween(open, token));
        }
        catch (BlockEndCondition e) {
            this.setSourceEnd(block, e.getToken());
            throw e;
        }
        while ((token = this.tokenizer.readToken()).getType() != 0 && token.getType() == 1) {
        }
        if (token.getType() == 49) {
            this.checkBlockValidity(block, token, new Class[]{AutoconfForElement.class, AutoconfWhileElement.class}, INVALID_DO);
        } else if (token.getType() == 41) {
            this.checkBlockValidity(block, token, new Class[]{AutoconfIfElement.class, AutoconfElifElement.class}, INVALID_THEN);
        } else {
            String exp = block instanceof AutoconfIfElement || block instanceof AutoconfElifElement ? "then" : "do";
            this.handleError(token, AutoconfEditorMessages.getFormattedString(MISSING_SPECIFIER, exp));
            this.tokenizer.unreadToken(token);
        }
        return token;
    }

    protected void parseCaseBlock(AutoconfElement parent, Token open, AutoconfElement block) throws BlockEndCondition {
        Token token;
        parent.addChild(block);
        this.setSourceStart(block, open);
        try {
            token = this.parseCaseExpression(block);
        }
        catch (BlockEndCondition e) {
            this.setSourceEnd(block, e.getToken());
            throw e;
        }
        block.setVar(this.getTokenSpanTextBetween(open, token));
        while (true) {
            AutoconfCaseConditionElement condition = new AutoconfCaseConditionElement();
            do {
                token = this.tokenizer.readToken();
                this.setSourceStart(condition, token);
            } while (token.getType() != 0 && token.getType() == 1);
            if (token.getType() == 54) break;
            try {
                Token start = token;
                token = this.parseCaseExpression(condition);
                condition.setName(this.getTokenSpanTextFromUpTo(start, token));
                while (true) {
                    this.parseStatement(condition);
                }
            }
            catch (BlockEndCondition e) {
                this.setSourceEnd(condition, e.getToken());
                if (condition.getSource().length() <= 0) continue;
                block.addChild(condition);
                if (e.getToken().getType() == 53) continue;
                token = e.getToken();
            }
            break;
        }
        this.setSourceEnd(block, token);
        if (token.getType() != 54) {
            this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, block.getName()));
        }
    }

    private String getTokenSpanTextBetween(Token open, Token close) {
        String text;
        int startOffset = open.getOffset() + open.getLength();
        int endOffset = close.getOffset();
        if (open.getDocument() != close.getDocument()) {
            return open.getText();
        }
        try {
            text = open.getDocument().get(startOffset, endOffset - startOffset).trim();
        }
        catch (BadLocationException e) {
            text = open.getText();
        }
        return text;
    }

    private String getTokenSpanTextFromUpTo(Token open, Token close) {
        String text;
        int startOffset = open.getOffset();
        int endOffset = close.getOffset();
        if (open.getDocument() != close.getDocument()) {
            return open.getText();
        }
        try {
            text = open.getDocument().get(startOffset, endOffset - startOffset).trim();
        }
        catch (BadLocationException e) {
            text = open.getText();
        }
        return text;
    }

    private void setSourceStart(AutoconfElement block, Token open) {
        int offset = open.getOffset();
        block.setDocument(open.getDocument());
        block.setStartOffset(offset);
    }

    private void setSourceEnd(AutoconfElement block, Token close) {
        int offset = close.getOffset() + close.getLength();
        if (block.getDocument() != null && block.getDocument() != close.getDocument()) {
            throw new IllegalStateException();
        }
        block.setDocument(close.getDocument());
        block.setEndOffset(offset);
    }

    private void setSourceEndBefore(AutoconfElement block, Token close) {
        int offset = close.getOffset();
        if (block.getDocument() != null && block.getDocument() != close.getDocument()) {
            throw new IllegalStateException();
        }
        block.setDocument(close.getDocument());
        block.setEndOffset(offset);
    }

    protected void parseStatement(AutoconfElement parent) throws BlockEndCondition {
        boolean atStart = true;
        while (true) {
            Token token = this.tokenizer.readToken();
            switch (token.getType()) {
                case 0: {
                    AutoconfElement element = parent;
                    while (element != null && !(element instanceof AutoconfRootElement)) {
                        this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, element.getName()));
                        element = element.getParent();
                    }
                    throw new BlockEndCondition(token);
                }
                case 1: 
                case 5: {
                    return;
                }
                case 6: {
                    this.checkMacro(parent, token);
                    atStart = false;
                    break;
                }
                case 60: {
                    atStart = false;
                    token = this.tokenizer.readToken();
                    break;
                }
                case 40: {
                    this.checkLineStart(token, atStart);
                    this.parseBlock(parent, token, new AutoconfIfElement());
                    break;
                }
                case 43: {
                    this.checkLineStart(token, atStart);
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfIfElement.class, AutoconfElifElement.class}, INVALID_ELIF);
                    this.parseBlock(parent, token, new AutoconfElifElement());
                    token = this.tokenizer.peekToken();
                    throw new BlockEndCondition(token);
                }
                case 42: {
                    this.checkLineStart(token, atStart);
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfIfElement.class, AutoconfElifElement.class}, INVALID_ELSE);
                    this.parseBlock(parent, token, new AutoconfElseElement());
                    token = this.tokenizer.peekToken();
                    throw new BlockEndCondition(token);
                }
                case 44: {
                    this.checkLineStart(token, atStart);
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfIfElement.class, AutoconfElifElement.class, AutoconfElseElement.class}, INVALID_FI);
                    throw new BlockEndCondition(token);
                }
                case 46: {
                    this.checkLineStart(token, atStart);
                    this.parseBlock(parent, token, new AutoconfForElement());
                    break;
                }
                case 45: {
                    this.checkLineStart(token, atStart);
                    this.parseBlock(parent, token, new AutoconfWhileElement());
                    break;
                }
                case 48: {
                    this.checkLineStart(token, atStart);
                    this.parseBlock(parent, token, new AutoconfUntilElement());
                    break;
                }
                case 47: {
                    this.checkLineStart(token, atStart);
                    this.parseBlock(parent, token, new AutoconfSelectElement());
                    break;
                }
                case 50: {
                    this.checkLineStart(token, atStart);
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfForElement.class, AutoconfWhileElement.class, AutoconfUntilElement.class, AutoconfSelectElement.class}, INVALID_DONE);
                    throw new BlockEndCondition(token);
                }
                case 51: {
                    this.checkLineStart(token, atStart);
                    this.parseCaseBlock(parent, token, new AutoconfCaseElement());
                    break;
                }
                case 53: {
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfCaseConditionElement.class}, IMPROPER_CASE_CONDITION);
                    throw new BlockEndCondition(token);
                }
                case 54: {
                    this.checkLineStart(token, atStart);
                    this.checkBlockValidity(parent, token, new Class[]{AutoconfCaseElement.class, AutoconfCaseConditionElement.class}, INVALID_ESAC);
                    throw new BlockEndCondition(token);
                }
                case 65: 
                case 66: {
                    this.parseHERE(parent, token);
                }
            }
        }
    }

    private void checkLineStart(Token token, boolean atStart) {
        if (!atStart) {
            this.handleError(token, AutoconfEditorMessages.getFormattedString(INVALID_TERMINATION, token.getText()));
        }
    }

    private void parseHERE(AutoconfElement parent, Token controlToken) {
        Token token = this.tokenizer.readToken();
        if (token.getType() == 1 || token.getType() == 0) {
            this.handleError(token, AutoconfEditorMessages.getString(INCOMPLETE_INLINE_MARKER));
        } else {
            String hereTag = token.getText();
            boolean atEOL = false;
            while (true) {
                Token eol;
                if ((token = this.tokenizer.readToken()).getType() == 0) {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, parent.getName()));
                    break;
                }
                if (token.getType() == 1) {
                    atEOL = true;
                    continue;
                }
                if (atEOL && token.getText().equals(hereTag) && (eol = this.tokenizer.readToken()).getType() == 1 && eol.getOffset() == token.getOffset() + token.getLength()) break;
                if (token.getType() == 6) {
                    this.checkMacro(parent, token);
                }
                atEOL = false;
            }
        }
    }

    protected Token parseExpression(AutoconfElement parent) throws BlockEndCondition {
        block9: while (true) {
            Token token = this.tokenizer.readToken();
            switch (token.getType()) {
                case 0: {
                    throw new BlockEndCondition(token);
                }
                case 6: {
                    token = this.checkMacro(parent, token);
                    continue block9;
                }
                case 1: 
                case 5: {
                    return token;
                }
                case 60: {
                    token = this.tokenizer.readToken();
                    continue block9;
                }
                case 52: {
                    if (!(parent instanceof AutoconfForElement) && !(parent instanceof AutoconfSelectElement)) {
                        return token;
                    }
                }
                case 41: 
                case 49: {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(INVALID_SPECIFIER, token.getText()));
                    this.tokenizer.unreadToken(token);
                    return token;
                }
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 50: 
                case 51: 
                case 53: 
                case 54: {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, parent.getName()));
                    this.tokenizer.unreadToken(token);
                    throw new BlockEndCondition(token);
                }
            }
        }
    }

    protected Token parseForExpression(AutoconfElement parent) throws BlockEndCondition {
        while (true) {
            Token token;
            if ((token = this.tokenizer.readToken()).getType() == 0) {
                throw new BlockEndCondition(token);
            }
            if (token.getType() == 6) {
                token = this.checkMacro(parent, token);
                continue;
            }
            if (token.getType() == 49) {
                this.tokenizer.unreadToken(token);
                return this.tokenizer.peekToken();
            }
            switch (token.getType()) {
                case 41: {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(INVALID_SPECIFIER, token.getText()));
                    this.tokenizer.unreadToken(token);
                    return token;
                }
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 50: 
                case 51: 
                case 53: 
                case 54: {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, parent.getName()));
                    this.tokenizer.unreadToken(token);
                    throw new BlockEndCondition(token);
                }
            }
        }
    }

    protected Token parseCaseExpression(AutoconfElement parent) throws BlockEndCondition {
        while (true) {
            Token token;
            if ((token = this.tokenizer.readToken()).getType() == 0) {
                throw new BlockEndCondition(token);
            }
            if (token.getType() == 6) {
                token = this.checkMacro(parent, token);
                continue;
            }
            if (parent instanceof AutoconfCaseElement && token.getType() == 52) {
                return token;
            }
            if (parent instanceof AutoconfCaseConditionElement && token.getType() == 3) {
                return token;
            }
            switch (token.getType()) {
                case 3: 
                case 5: 
                case 41: 
                case 49: 
                case 52: {
                    if (parent instanceof AutoconfCaseElement) {
                        this.handleError(token, AutoconfEditorMessages.getString(INVALID_IN));
                    } else {
                        this.handleError(token, AutoconfEditorMessages.getString(IMPROPER_CASE_CONDITION));
                    }
                    return token;
                }
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 50: 
                case 51: 
                case 53: 
                case 54: {
                    this.handleError(token, AutoconfEditorMessages.getFormattedString(UNTERMINATED_CONSTRUCT, parent.getName()));
                    this.tokenizer.unreadToken(token);
                    throw new BlockEndCondition(token);
                }
            }
        }
    }

    private void checkBlockValidity(AutoconfElement parent, Token token, Class<?>[] classes, String errorMessage) {
        int i = 0;
        while (i < classes.length) {
            if (classes[i].isInstance(parent)) {
                return;
            }
            ++i;
        }
        this.handleError(token, AutoconfEditorMessages.getFormattedString(errorMessage, parent.getName(), token.getText()));
    }

    private AutoconfMacroElement createMacroElement(String name) {
        if (name.equals("AC_INIT")) {
            return new AcInitElement(name);
        }
        return new AutoconfMacroElement(name);
    }

    private Token checkMacro(AutoconfElement parent, Token token) {
        Token peek;
        boolean hasArguments;
        String name = token.getText();
        boolean bl = hasArguments = this.tokenizer.peekToken().getType() == 2;
        if (this.macroDetector == null || !this.macroDetector.isMacroIdentifier(name)) {
            if (m4builtins.contains(name)) {
                if (!name.equals("dnl") && !hasArguments) {
                    return token;
                }
            } else {
                return token;
            }
        }
        AutoconfMacroElement macro = this.createMacroElement(name);
        token = this.parseMacro(macro, token);
        if ("dnl".equals(name)) {
            while ((token = this.tokenizer.readToken()).getType() != 0 && token.getType() != 1) {
            }
            macro = null;
        } else if ("changequote".equals(name)) {
            this.validateMacroParameterCount(macro, token, 2);
            parm0 = "`";
            String parm1 = "'";
            if (macro.getParameterCount() >= 1) {
                parm0 = macro.getParameter(0);
            }
            if (macro.getParameterCount() >= 2) {
                parm1 = macro.getParameter(1);
            }
            this.tokenizer.setM4Quote(parm0, parm1);
        } else if ("changecom".equals(name)) {
            this.validateMacroParameterCount(macro, token, 2);
            parm0 = "#";
            String parm1 = "\n";
            if (macro.getParameterCount() >= 1) {
                parm0 = macro.getParameter(0);
            }
            if (macro.getParameterCount() >= 2) {
                parm1 = macro.getParameter(1);
            }
            this.tokenizer.setM4Comment(parm0, parm1);
        }
        if (macro != null) {
            parent.addChild(macro);
        }
        if (!(parent instanceof AutoconfMacroArgumentElement || parent instanceof AutoconfMacroElement || parent instanceof AutoconfForElement || (peek = this.tokenizer.peekToken()).getType() != 3)) {
            this.handleError(peek, AutoconfEditorMessages.getString(UNMATCHED_RIGHT_PARENTHESIS));
        }
        return token;
    }

    private void validateMacroParameterCount(AutoconfMacroElement macro, Token token, int count) {
        if (macro.getParameterCount() < count) {
            this.handleError(token, AutoconfEditorMessages.getFormattedString("M4MacroArgsTooFew", macro.getName(), 2));
        } else if (macro.getParameterCount() > count) {
            this.handleError(token, AutoconfEditorMessages.getFormattedString("M4MacroArgsTooMany", macro.getName(), 2));
        }
    }

    protected Token parseMacro(AutoconfMacroElement macro, Token macroName) {
        this.setSourceStart(macro, macroName);
        this.tokenizer.setM4Context(true);
        Token token = this.tokenizer.readToken();
        if (token.getType() == 2) {
            token = this.parseMacroArguments(macro);
            this.setSourceEnd(macro, token);
        } else {
            this.tokenizer.unreadToken(token);
            this.setSourceEnd(macro, macroName);
        }
        this.tokenizer.setM4Context(false);
        if (this.macroValidator != null) {
            try {
                this.macroValidator.validateMacroCall(macro);
            }
            catch (ParseException e) {
                this.errorHandler.handleError(e);
            }
            catch (InvalidMacroException e) {
                this.handleError(e);
            }
        }
        return token;
    }

    protected Token parseMacroArguments(AutoconfMacroElement macro) {
        AutoconfElement[] children;
        Token token;
        Token argStart = null;
        Token argEnd = null;
        StringBuilder argBuffer = new StringBuilder();
        AutoconfMacroArgumentElement arg = new AutoconfMacroArgumentElement();
        while (true) {
            if ((token = this.tokenizer.readToken()).getType() == 1) {
                if (argBuffer.length() <= 0) continue;
                argBuffer.append(token.getText());
                continue;
            }
            if (token.getType() == 4 || token.getType() == 3 || token.getType() == 0) {
                arg.setName(argBuffer.toString());
                argBuffer.setLength(0);
                if (argStart != null && argEnd != null) {
                    this.setSourceStart(arg, argStart);
                    this.setSourceEnd(arg, argEnd);
                } else if (argEnd != null) {
                    this.setSourceStart(arg, argStart);
                    this.setSourceEndBefore(arg, token);
                } else {
                    this.setSourceStart(arg, token);
                    this.setSourceEndBefore(arg, token);
                }
                macro.addChild(arg);
                if (token.getType() != 4) break;
                argStart = null;
                argEnd = null;
                arg = new AutoconfMacroArgumentElement();
                continue;
            }
            if (argStart == null) {
                argStart = token;
            }
            argEnd = token;
            if (argBuffer.length() > 0 && token.followsSpace()) {
                argBuffer.append(' ');
            }
            argBuffer.append(token.getText());
            if (token.getType() != 6) continue;
            argEnd = this.checkMacro(arg, token);
        }
        if (token.getType() != 3) {
            this.handleError(token, AutoconfEditorMessages.getString(UNMATCHED_LEFT_PARENTHESIS));
        }
        if ((children = macro.getChildren()).length > 0) {
            macro.setVar(children[0].getVar());
        }
        return token;
    }

    protected void handleError(Token token, String message) {
        this.handleMessage(token, message, 2);
    }

    protected void handleWarning(Token token, String message) {
        this.handleMessage(token, message, 1);
    }

    protected void handleMessage(Token token, String message, int severity) {
        if (this.errorHandler != null) {
            int lineNumber = 0;
            int startColumn = 0;
            int endColumn = 0;
            try {
                lineNumber = token.getDocument().getLineOfOffset(token.getOffset());
                int lineOffs = token.getDocument().getLineOffset(lineNumber);
                startColumn = token.getOffset() - lineOffs;
                endColumn = startColumn + token.getLength();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.errorHandler.handleError(new ParseException(message, token.getOffset(), token.getOffset() + token.getLength(), lineNumber, startColumn, endColumn, severity));
        }
    }

    protected void handleError(InvalidMacroException exception) {
        AutoconfElement element = exception.getBadElement();
        if (this.errorHandler != null) {
            int lineNumber = 0;
            int startColumn = 0;
            int endColumn = 0;
            try {
                lineNumber = element.getDocument().getLineOfOffset(element.getStartOffset());
                int lineOffs = element.getDocument().getLineOffset(lineNumber);
                startColumn = element.getStartOffset() - lineOffs;
                endColumn = startColumn + element.getLength();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.errorHandler.handleError(new ParseException(exception.getMessage(), element.getStartOffset(), element.getEndOffset(), lineNumber, startColumn, endColumn, 2));
        }
    }

    public IAutoconfErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static class BlockEndCondition
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Token token;

        public BlockEndCondition(Token token) {
            this.token = token;
        }

        public Token getToken() {
            return this.token;
        }
    }

    static class ExprEndCondition
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Token token;

        public ExprEndCondition(Token token) {
            this.token = token;
        }

        public Token getToken() {
            return this.token;
        }
    }
}

