/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.breakpoint.actions;

import org.eclipse.cdt.debug.core.breakpointactions.ICLIDebugActionEnabler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CLIDebugActionEnabler
implements ICLIDebugActionEnabler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fServiceTracker;
    private final ICommandControlService.ICommandControlDMContext fContext;

    public CLIDebugActionEnabler(DsfExecutor executor, DsfServicesTracker serviceTracker, IDMContext context) {
        this.fExecutor = executor;
        this.fServiceTracker = serviceTracker;
        this.fContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
        assert (this.fContext != null);
    }

    public void execute(String commandmulti) throws Exception {
        String[] commands = commandmulti.split("\\r?\\n");
        int j = 0;
        while (j < commands.length) {
            String single = commands[j];
            this.executeSingleCommand(single);
            ++j;
        }
    }

    private boolean isMIOperation(String operation) {
        return operation.startsWith("-");
    }

    private void executeSingleCommand(String str) {
        final MICommand cmd = !this.isMIOperation(str) && !CLIEventProcessor.isSteppingOperation(str) ? new MIInterpreterExecConsole((IDMContext)this.fContext, str) : new CLICommand((IDMContext)this.fContext, str);
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                ICommandControlService commandControl = (ICommandControlService)CLIDebugActionEnabler.this.fServiceTracker.getService(ICommandControlService.class);
                if (commandControl != null) {
                    commandControl.queueCommand(cmd, (DataRequestMonitor)new ImmediateDataRequestMonitor());
                } else {
                    GdbPlugin.log((IStatus)new Status(1, "org.eclipse.cdt.dsf.gdb", "Unable to find service to execute breakpoint command"));
                }
            }
        });
    }
}

