/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.LineRoot;

public class BlockBox
extends CompositeBox {
    int height;
    private int y;
    BlockFlow owner;

    BlockBox(BlockFlow owner) {
        this.owner = owner;
    }

    @Override
    public void add(FlowBox box) {
        this.width = Math.max(this.width, box.getWidth());
        this.height = Math.max(this.height, box.getBaseline() + box.getDescent());
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return true;
    }

    @Override
    public int getAscent() {
        return 0;
    }

    @Override
    public int getBaseline() {
        return this.y;
    }

    @Override
    int getBottomMargin() {
        return this.owner.getBottomMargin();
    }

    @Override
    public int getDescent() {
        return this.height;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    LineRoot getLineRoot() {
        return null;
    }

    @Override
    int getTopMargin() {
        return this.owner.getTopMargin();
    }

    public void setHeight(int h) {
        this.height = h;
    }

    @Override
    public void setLineTop(int y) {
        this.y = y;
    }

    Rectangle toRectangle() {
        return new Rectangle(this.getX(), this.y, Math.max(this.getWidth(), this.recommendedWidth), this.height);
    }
}

